/*
 * Decompiled with CFR 0.152.
 */
package ControladorQSO_MVC;

import ModeloQSO_MVC.CompRadio;
import ModeloQSO_MVC.CompRadioQrzQra;
import ModeloQSO_MVC.ContactoRadio;
import ModeloQSO_MVC.GestorCorreo;
import ModeloQSO_MVC.ListContactsForExportXML;
import ModeloQSO_MVC.ListForExportXML;
import ModeloQSO_MVC.ModeloQSO;
import VistaQSO_MVC.ComboItem;
import VistaQSO_MVC.VistaQSO;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControladorQSO {
    protected static final Logger parentLogger = LogManager.getLogger();
    private Logger logger = parentLogger;
    private static final ControladorQSO controladorQSO = new ControladorQSO();
    private String dirEstaciones;
    private String fichQsoEstaciones;
    private String fichQsoContactos;
    private String dirFicherosContest;
    private String systemFileEncoding;
    private boolean ignorarEncoding;
    private Properties m_properties;
    private Properties urlServerDBproperties;

    private ControladorQSO() {
    }

    public static ControladorQSO getInstance() {
        return controladorQSO;
    }

    public String getDirEstaciones() {
        return this.dirEstaciones;
    }

    public String getFichQsoEstaciones() {
        return this.fichQsoEstaciones;
    }

    public String getFichQsoContactos() {
        return this.fichQsoContactos;
    }

    public String getDirFicherosContest() {
        return this.dirFicherosContest;
    }

    public String getAbsDirFicherosContest() {
        return this.dirEstaciones + System.getProperty("file.separator") + this.dirFicherosContest;
    }

    public String getMailUser() {
        return this.m_properties.getProperty("mail.user.contest");
    }

    public String getMailPasswd() {
        String pwd = this.m_properties.getProperty("mail.user.passwd");
        StringBuilder stringBuilderPasswd = new StringBuilder(pwd);
        return stringBuilderPasswd.reverse().toString();
    }

    public String getSystemFileEncoding() {
        return this.systemFileEncoding;
    }

    public boolean isIgnorarEncoding() {
        return this.ignorarEncoding;
    }

    public void setDirEstaciones(String dirEstaciones) {
        this.dirEstaciones = dirEstaciones;
    }

    public void setFichQsoEstaciones(String fichQsoEstaciones) {
        this.fichQsoEstaciones = fichQsoEstaciones;
    }

    public void setFichQsoContactos(String fichQsoContactos) {
        this.fichQsoContactos = fichQsoContactos;
    }

    public void setDirFicherosContest(String dirFicherosContest) {
        this.dirFicherosContest = dirFicherosContest;
    }

    public void setSystemFileEncoding(String systemFileEncoding) {
        this.systemFileEncoding = systemFileEncoding;
    }

    public void setIgnorarEncoding(String ignorarEncoding) {
        this.ignorarEncoding = ignorarEncoding.equals("true");
    }

    public void startApplication() {
        new File(this.getDirEstaciones()).mkdirs();
        new File(this.getDirEstaciones() + System.getProperty("file.separator") + this.getDirFicherosContest()).mkdirs();
        ArrayList<CompRadio> listCR = this.generaListaCompDeXML(ModeloQSO.getInstance().getEstaciones(this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoEstaciones()));
        String contactos = ModeloQSO.getInstance().getContactos(this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoContactos());
        VistaQSO.getInstance().recuperarSesionContest(contactos);
        VistaQSO.getInstance().inicializaListas(listCR);
        VistaQSO.getInstance().setVisible(true);
        this.leerPropiedades();
        VistaQSO.getInstance().comprobarEncoding();
        this.leerPropiedadesUrlDBserver();
    }

    public DefaultComboBoxModel<String> getValuesComboBoxEmailAdmin() {
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>();
        dcbm.addElement(this.m_properties.getProperty("mail.admin1.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.admin2.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.admin3.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.admin4.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.admin5.contest"));
        return dcbm;
    }

    public DefaultComboBoxModel<String> getValuesComboBoxConfirmEmail() {
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>();
        dcbm.addElement(this.m_properties.getProperty("mail.confirm1.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.confirm2.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.confirm3.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.confirm4.contest"));
        dcbm.addElement(this.m_properties.getProperty("mail.confirm5.contest"));
        return dcbm;
    }

    public DefaultComboBoxModel<ComboItem> getValuesComboBoxUrlDBserver() {
        DefaultComboBoxModel<ComboItem> dcbm = new DefaultComboBoxModel<ComboItem>();
        for (Object key : this.urlServerDBproperties.keySet()) {
            dcbm.addElement(new ComboItem(this.urlServerDBproperties.getProperty(key.toString()), (String)key));
        }
        return dcbm;
    }

    public boolean enviarCorreosConAdifFile(File fichero, String user, String password, String emailAdmin, String emailConfirm) {
        this.logger.debug("Enviando fichero: " + fichero.getAbsolutePath() + " user: " + user + " password: **** :-) ");
        this.logger.debug("Email Admin: " + emailAdmin);
        this.logger.debug("Email Confirm: " + emailConfirm);
        GestorCorreo gc = new GestorCorreo(this.m_properties, user, password, emailAdmin, "javaqso@gmail.com", emailConfirm);
        boolean enviado = gc.enviarFichero(fichero);
        return enviado;
    }

    public void leerPropiedades() {
        Properties defaultProp = new Properties();
        defaultProp.setProperty("mail.smtp.host", "smtp.gmail.com");
        defaultProp.setProperty("mail.smtp.starttls.enable", "true");
        defaultProp.setProperty("mail.smtp.port", "587");
        defaultProp.setProperty("mail.smtp.auth", "true");
        defaultProp.setProperty("mail.user.contest", "javaqso@gmail.com");
        defaultProp.setProperty("mail.user.passwd", "ohimqtyhzumpwqvv");
        defaultProp.setProperty("mail.admin1.contest", "log@activandocb.com");
        defaultProp.setProperty("mail.admin2.contest", "84lrcb@gmail.com");
        defaultProp.setProperty("mail.confirm1.contest", "tuCorreo1@tuDominio");
        this.m_properties = new Properties();
        try {
            try (FileInputStream input = new FileInputStream(this.getDirEstaciones() + System.getProperty("file.separator") + "mailjavaqso.properties");){
                this.m_properties.load(input);
            }
            catch (FileNotFoundException ex) {
                this.m_properties = defaultProp;
                try (FileOutputStream output = new FileOutputStream(this.getDirEstaciones() + System.getProperty("file.separator") + "mailjavaqso.properties");){
                    this.m_properties.store(output, "Editar este fichero con datos de su proveedor, por defecto tiene los de gmail.");
                }
                catch (IOException e) {
                    this.logger.debug("Excepci\u00f3n lanzada en leerPropiedades para mail: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed! ", (Throwable)e);
        }
    }

    public void leerPropiedadesUrlDBserver() {
        Properties defaultProp = new Properties();
        defaultProp.setProperty("url.estaciones.lrcb", "https://ea4gxr.es/download/javaQsoEstaciones.lrcb.xml");
        defaultProp.setProperty("url.estaciones.ea4gxr.lrcb", "https://ea4gxr.es/download/javaQsoEstaciones.lrcb.xml");
        this.urlServerDBproperties = new Properties();
        try {
            try (FileInputStream input = new FileInputStream(this.getDirEstaciones() + System.getProperty("file.separator") + "urlupdate.properties");){
                this.urlServerDBproperties.load(input);
            }
            catch (FileNotFoundException ex) {
                this.urlServerDBproperties = defaultProp;
                try (FileOutputStream output = new FileOutputStream(this.getDirEstaciones() + System.getProperty("file.separator") + "urlupdate.properties");){
                    this.urlServerDBproperties.store(output, " Editar este fichero con las url de servidor de BD estaciones. \n# url.estaciones.cqbreico=https://\n# url.estaciones.ure=https:// \n# url.estaciones.otro=https:// \n# url.local.file.linux=file:///home/.../.xml \n# url.local.file.windows=file:///C:\\\\Users\\\\...\\\\.xml ");
                }
                catch (IOException e) {
                    this.logger.debug("Excepci\u00f3n lanzada en leerPropiedadesUrlDBserver: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed! ", (Throwable)e);
        }
    }

    public void obtenerEstacionesJavaQsoDeServer(String url) throws IOException {
        String fileToDownload = this.getDirEstaciones() + System.getProperty("file.separator") + "javaQsoEstaciones.download.xml";
        String urlDBserver = url;
        this.logger.debug("Url en obtenerEstacionesJavaQsoDeServer:" + urlDBserver);
        try {
            Files.copy(new URL(urlDBserver).openStream(), Paths.get(fileToDownload, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (MalformedURLException ex) {
            this.logger.debug("Excepci\u00f3n lanzada en obtenerEstacionesJavaQsoDeServer: " + ex.getMessage());
            throw ex;
        }
        Scanner scanner = new Scanner(new File(fileToDownload));
        int contador = 0;
        while (scanner.hasNext()) {
            String currentLine = scanner.next();
            if (currentLine.contains("<autor>EA4GXR")) {
                ++contador;
            }
            if (!currentLine.contains("/JavaQso")) continue;
            ++contador;
        }
        if (contador != 2) {
            scanner.close();
            throw new IOException("El fichero no es de javaQso o est\u00e1 incompleto");
        }
        this.logger.debug("Hemos encontrado <autor>EA4GXR y /JavaQso, el fichero es de javaQso y est\u00e1 entero.");
        scanner.close();
    }

    public void actualizaListaEstacionesRadioDesdeFicheroDescargado(boolean sobreescribir) throws IOException {
        int procesar = 1;
        ArrayList<CompRadio> listCR = new ArrayList<CompRadio>();
        if (!sobreescribir) {
            listCR = this.generaListaCompDeXML(ModeloQSO.getInstance().getEstaciones(this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoEstaciones()));
        }
        listCR.forEach(cr -> {
            cr.setQrz(cr.getQrz().trim());
            cr.setQra(cr.getQra().trim());
        });
        listCR.forEach(cr -> cr.setQrz(cr.getQrz().split("_")[0]));
        ArrayList<CompRadioQrzQra> listCrQrzQra = new ArrayList<CompRadioQrzQra>();
        for (CompRadio cmpr : listCR) {
            this.logger.debug("cmpr.qrz =  " + cmpr.getQrz());
            listCrQrzQra.add(new CompRadioQrzQra(cmpr, true));
        }
        this.logger.debug("listCrQrzQra.size() 1 =  " + listCrQrzQra.size());
        ArrayList<CompRadio> listCR_new = this.generaListaCompDeXML(ModeloQSO.getInstance().getEstaciones(this.getDirEstaciones() + System.getProperty("file.separator") + "javaQsoEstaciones.download.xml"));
        listCR_new.forEach(cr -> {
            cr.setQrz(cr.getQrz().trim());
            cr.setQra(cr.getQra().trim());
        });
        listCR_new.forEach(cr -> cr.setQrz(cr.getQrz().split("_")[0]));
        ArrayList<CompRadioQrzQra> listCrQrzQra_new = new ArrayList<CompRadioQrzQra>();
        for (CompRadio cmpr : listCR_new) {
            this.logger.debug("cmpr.qrz =  " + cmpr.getQrz());
            listCrQrzQra_new.add(new CompRadioQrzQra(cmpr));
        }
        this.logger.debug("listCrQrzQra_new.size() =  " + listCrQrzQra_new.size());
        listCrQrzQra.addAll(listCrQrzQra_new);
        this.logger.debug("listCrQrzQra.size() 2 =  " + listCrQrzQra.size());
        List listTmp = listCrQrzQra.stream().sorted().distinct().collect(Collectors.toList());
        listCrQrzQra.clear();
        listCrQrzQra.addAll(listTmp);
        this.logger.debug("listCrQrzQra.size() 3 =  " + listCrQrzQra.size());
        int indexRep = 0;
        int tamLista = listCrQrzQra.size();
        this.logger.debug("tamLista =  " + tamLista);
        for (int index = 0; index < tamLista; ++index) {
            this.logger.debug("index =  " + index);
            CompRadioQrzQra compRadio = (CompRadioQrzQra)listCrQrzQra.get(index);
            this.logger.debug("qrz = " + compRadio.getQrz());
            this.logger.debug("qra = " + compRadio.getQra());
            String qrz = compRadio.getQrz();
            String qra = compRadio.getQra();
            if (procesar != -1 && !compRadio.getOld()) {
                procesar = VistaQSO.getInstance().continuarCargaSinPreguntar(compRadio.getQrz().split("_")[0], compRadio.getQra());
            }
            if (procesar == 2) {
                return;
            }
            if (procesar == 0) {
                listCrQrzQra.remove(index);
                this.logger.debug("index borrado  = " + index);
                --tamLista;
                --index;
                procesar = 1;
                continue;
            }
            if (indexRep > 0) {
                qrz = qrz.split("_")[0];
            }
            if (index >= tamLista - 1) continue;
            CompRadioQrzQra crAux = (CompRadioQrzQra)listCrQrzQra.get(index + 1);
            this.logger.debug("qrz siguiente= " + crAux.getQrz());
            if (crAux.getQrz().equals(qrz)) {
                this.logger.debug("index repetido =  " + (index + 1));
                this.logger.debug("qrz anterior = " + qrz);
                crAux.setQrz(qrz + "_" + Integer.toString(++indexRep));
                this.logger.debug("qrz nuevo = " + crAux.getQrz());
                continue;
            }
            indexRep = 0;
        }
        ArrayList<CompRadio> listCR_aux = new ArrayList<CompRadio>();
        for (CompRadioQrzQra cmprAux : listCrQrzQra) {
            CompRadio cr2 = new CompRadio(cmprAux.getQrz(), cmprAux.getQra(), cmprAux.getQth(), cmprAux.getLocator(), cmprAux.getRc(), cmprAux.getEmail(), cmprAux.getPobox());
            listCR_aux.add(cr2);
        }
        this.logger.debug("listCrQrzQra.size() 4 =  " + listCrQrzQra.size());
        this.logger.debug("listCR_aux.size()  =  " + listCR_aux.size());
        this.guardarCompXML(listCR_aux);
        VistaQSO.getInstance().inicializaListas(listCR_aux);
    }

    public String generaXMLdeCompRadio(ArrayList<CompRadio> lcr) {
        ListForExportXML listComp = new ListForExportXML();
        listComp.setListCR(lcr);
        XStream xstream = new XStream(new DomDriver());
        String[] classes = new String[]{"ModeloQSO_MVC.ContactoRadio", "ModeloQSO_MVC.CompRadio", "ModeloQSO_MVC.ListForExportXML", "ModeloQSO_MVC.ListContactsForExportXML"};
        xstream.allowTypes(classes);
        xstream.alias("Estacion", CompRadio.class);
        xstream.alias("JavaQso", ListForExportXML.class);
        xstream.addImplicitCollection(ListForExportXML.class, "listCR");
        String xml = xstream.toXML(listComp);
        this.logger.debug("xml en generaXMLdeCompRadio = " + xml);
        return xml;
    }

    public ArrayList<CompRadio> generaListaCompDeXML(String xml) {
        XStream xstream = new XStream(new DomDriver());
        xstream.addPermission(AnyTypePermission.ANY);
        String[] classes = new String[]{"ModeloQSO_MVC.ContactoRadio", "ModeloQSO_MVC.CompRadio", "ModeloQSO_MVC.ListForExportXML", "ModeloQSO_MVC.ListContactsForExportXML"};
        xstream.allowTypes(classes);
        xstream.alias("Estacion", CompRadio.class);
        xstream.alias("JavaQso", ListForExportXML.class);
        xstream.addImplicitCollection(ListForExportXML.class, "listCR");
        ListForExportXML listComp = (ListForExportXML)xstream.fromXML(xml);
        return listComp.getListCR();
    }

    public String generaXMLdeContactosRadio(ListContactsForExportXML lcfex) {
        XStream xstream = new XStream(new DomDriver());
        String[] classes = new String[]{"ModeloQSO_MVC.ContactoRadio", "ModeloQSO_MVC.CompRadio", "ModeloQSO_MVC.ListForExportXML", "ModeloQSO_MVC.ListContactsForExportXML"};
        xstream.allowTypes(classes);
        xstream.alias("Estacion", ContactoRadio.class);
        xstream.alias("JavaQso", ListContactsForExportXML.class);
        xstream.addImplicitCollection(ListContactsForExportXML.class, "listCR");
        String xml = xstream.toXML(lcfex);
        this.logger.debug("xml en generaXMLdeContactosRadio = " + xml);
        return xml;
    }

    public ListContactsForExportXML generaListaContactosDeXML(String xml) {
        XStream xstream = new XStream(new DomDriver());
        String[] classes = new String[]{"ModeloQSO_MVC.ContactoRadio", "ModeloQSO_MVC.CompRadio", "ModeloQSO_MVC.ListForExportXML", "ModeloQSO_MVC.ListContactsForExportXML"};
        xstream.allowTypes(classes);
        xstream.alias("Estacion", ContactoRadio.class);
        xstream.alias("JavaQso", ListContactsForExportXML.class);
        xstream.addImplicitCollection(ListContactsForExportXML.class, "listCR");
        ListContactsForExportXML listContactos = (ListContactsForExportXML)xstream.fromXML(xml);
        return listContactos;
    }

    public boolean respaldarDBantesdeActualizacion(ArrayList<CompRadio> lcr) {
        File respaldo = new File(this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoEstaciones() + "." + LocalDate.now());
        if (!respaldo.exists()) {
            return ModeloQSO.getInstance().setEstaciones(this.generaXMLdeCompRadio(lcr), this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoEstaciones() + "." + LocalDate.now());
        }
        this.logger.debug("Ya existe el fichero" + respaldo.getAbsolutePath() + " no hacemos nada, se habr\u00e1 copiado ya en un intento anterior");
        return false;
    }

    public boolean guardarCompXML(ArrayList<CompRadio> lcr) {
        ModeloQSO.getInstance().setEstaciones(this.generaXMLdeCompRadio(lcr), this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoEstaciones() + ".bak");
        return ModeloQSO.getInstance().setEstaciones(this.generaXMLdeCompRadio(lcr), this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoEstaciones());
    }

    public boolean guardarContactosXML(ListContactsForExportXML lcfex) {
        ModeloQSO.getInstance().setContactos(this.generaXMLdeContactosRadio(lcfex), this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoContactos() + ".bak");
        return ModeloQSO.getInstance().setContactos(this.generaXMLdeContactosRadio(lcfex), this.getDirEstaciones() + System.getProperty("file.separator") + this.getFichQsoContactos());
    }

    public boolean guardarContestAdifFile(ListContactsForExportXML lcfex, File file) {
        this.logger.debug("AbsPath of file: " + file.getAbsolutePath());
        return ModeloQSO.getInstance().setAdifRecords(lcfex, file.getAbsolutePath());
    }

    public ListContactsForExportXML cargarContestAdifFile(File file) {
        this.logger.debug("AbsPath of file: " + file.getAbsolutePath());
        return ModeloQSO.getInstance().getAdifRecords(file.getAbsolutePath());
    }

    public boolean verificarNumeroLineasFicheroControlador(File file, int numLines) {
        return ModeloQSO.getInstance().verificarNumeroLineasFicheroModelo(file, numLines);
    }
}

