/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC;

import ModeloQSO_MVC.ContactoRadio;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class ContactTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"N", "QRZ", "QRA", "QTH", "Locator", "R", "S", "Hora", "QSL", "Act"};
    private ArrayList<ContactoRadio> listaContactos;

    public ContactTableModel(ArrayList<ContactoRadio> listaContactos) {
        this.listaContactos = listaContactos;
    }

    public ContactTableModel() {
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public ArrayList<ContactoRadio> getListaContactos() {
        return this.listaContactos;
    }

    public void setListaContactos(ArrayList<ContactoRadio> listaContactos) {
        this.listaContactos = listaContactos;
    }

    public boolean add(ContactoRadio e) {
        return this.listaContactos.add(e);
    }

    public ContactoRadio getContactoRadio(String qrz, String qra) {
        ContactoRadio crAux = new ContactoRadio();
        crAux.setQrz(qrz);
        crAux.setQra(qra);
        int index = this.listaContactos.indexOf(crAux);
        if (index >= 0) {
            return this.listaContactos.get(index);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        int size = this.listaContactos == null ? 0 : this.listaContactos.size();
        return size;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object tmp = null;
        switch (columnIndex) {
            case 0: {
                tmp = this.listaContactos.get(rowIndex).getNum();
                break;
            }
            case 1: {
                tmp = this.listaContactos.get(rowIndex).getQrz();
                break;
            }
            case 2: {
                tmp = this.listaContactos.get(rowIndex).getQra();
                break;
            }
            case 3: {
                tmp = this.listaContactos.get(rowIndex).getQth();
                break;
            }
            case 4: {
                tmp = this.listaContactos.get(rowIndex).getLocator();
                break;
            }
            case 5: {
                tmp = this.listaContactos.get(rowIndex).getSigRadio();
                break;
            }
            case 6: {
                tmp = this.listaContactos.get(rowIndex).getSigSantiago();
                break;
            }
            case 7: {
                tmp = this.listaContactos.get(rowIndex).getHoraContacto().format(DateTimeFormatter.ofPattern("HH:mm"));
                break;
            }
            case 8: {
                tmp = this.listaContactos.get(rowIndex).isQsl();
                break;
            }
            case 9: {
                tmp = this.listaContactos.get(rowIndex).isActivador();
                break;
            }
            case 10: {
                tmp = this.listaContactos.get(rowIndex).getNotas();
            }
        }
        return tmp;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Integer.class;
            }
            case 7: {
                return LocalTime.class;
            }
            case 8: 
            case 9: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
    }
}

