/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC;

import ModeloQSO_MVC.CompRadio;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;

public class ContactoRadio
implements Comparable<ContactoRadio>,
Serializable {
    private Integer num;
    private CompRadio compRadio;
    private String sigRadio;
    private String sigSantiago;
    private LocalTime horaContacto;
    private LocalDateTime diaContacto;
    private boolean qsl;
    private boolean activador;
    private String notas;

    public Integer getNum() {
        return this.num;
    }

    public String getQrz() {
        return this.compRadio.getQrz();
    }

    public String getQra() {
        return this.compRadio.getQra();
    }

    public String getQth() {
        return this.compRadio.getQth();
    }

    public String getLocator() {
        return this.compRadio.getLocator();
    }

    public String getRc() {
        return this.compRadio.getRc();
    }

    public String getEmail() {
        return this.compRadio.getEmail();
    }

    public String getPobox() {
        return this.compRadio.getPobox();
    }

    public String getSigRadio() {
        return this.sigRadio;
    }

    public String getSigSantiago() {
        return this.sigSantiago;
    }

    public LocalTime getHoraContacto() {
        return this.horaContacto;
    }

    public LocalDateTime getDiaContacto() {
        return this.diaContacto;
    }

    public boolean isQsl() {
        return this.qsl;
    }

    public boolean isActivador() {
        return this.activador;
    }

    public String getNotas() {
        return this.notas;
    }

    public CompRadio getCompRadio() {
        return this.compRadio;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public void setQrz(String qrz) {
        this.compRadio.setQrz(qrz);
    }

    public void setQra(String qra) {
        this.compRadio.setQra(qra);
    }

    public void setQth(String qth) {
        this.compRadio.setQth(qth);
    }

    public void setLocator(String locator) {
        this.compRadio.setLocator(locator);
    }

    public void setRc(String rc) {
        this.compRadio.setRc(rc);
    }

    public void setEmail(String email) {
        this.compRadio.setEmail(email);
    }

    public void setPobox(String pobox) {
        this.compRadio.setPobox(pobox);
    }

    public void setSigRadio(String sigRadio) {
        this.sigRadio = sigRadio;
    }

    public void setSigSantiago(String sigSantiago) {
        this.sigSantiago = sigSantiago;
    }

    public void setHoraContacto(LocalTime horaContacto) {
        this.horaContacto = horaContacto;
    }

    public void setDiaContacto(LocalDateTime diaContacto) {
        this.diaContacto = diaContacto;
    }

    public void setQsl(boolean qsl) {
        this.qsl = qsl;
    }

    public void setActivador(boolean activador) {
        this.activador = activador;
    }

    public void setNotas(String notas) {
        this.notas = this.capitalizeFirstLetter(notas);
    }

    public void setCompRadio(CompRadio compRadio) {
        this.compRadio = compRadio;
    }

    public ContactoRadio() {
        this.num = 0;
        this.compRadio = new CompRadio();
        this.sigRadio = "";
        this.sigSantiago = "";
        this.horaContacto = LocalTime.now();
        this.diaContacto = LocalDateTime.now();
        this.qsl = false;
        this.activador = false;
        this.notas = "";
    }

    public ContactoRadio(ContactoRadio cAux) {
        this.compRadio = new CompRadio();
        this.num = cAux.getNum();
        this.compRadio.setQrz(cAux.getCompRadio().getQrz());
        this.compRadio.setQra(cAux.getCompRadio().getQra());
        this.compRadio.setQth(cAux.getCompRadio().getQth());
        this.compRadio.setLocator(cAux.getCompRadio().getLocator());
        this.compRadio.setRc(cAux.getCompRadio().getRc());
        this.compRadio.setEmail(cAux.getCompRadio().getEmail());
        this.compRadio.setPobox(cAux.getCompRadio().getPobox());
        this.sigRadio = cAux.getSigRadio();
        this.sigSantiago = cAux.getSigSantiago();
        this.horaContacto = cAux.getHoraContacto();
        this.diaContacto = cAux.getDiaContacto();
        this.qsl = cAux.isQsl();
        this.activador = cAux.isActivador();
        this.notas = this.capitalizeFirstLetter(cAux.getNotas());
    }

    public ContactoRadio(Integer num, String qrz, String qra, String qth, String locator, String rc, String email, String pobox, String sigRadio, String sigSantiago, boolean qsl, boolean activador, String notas) {
        this.compRadio = new CompRadio();
        this.num = num;
        this.compRadio.setQrz(qrz);
        this.compRadio.setQra(qra);
        this.compRadio.setQth(qth);
        this.compRadio.setLocator(locator);
        this.compRadio.setRc(rc);
        this.compRadio.setEmail(email);
        this.compRadio.setPobox(pobox);
        this.sigRadio = sigRadio;
        this.sigSantiago = sigSantiago;
        this.horaContacto = LocalTime.now();
        this.diaContacto = LocalDateTime.now();
        this.qsl = qsl;
        this.activador = activador;
        this.notas = this.capitalizeFirstLetter(notas);
    }

    @Override
    public int compareTo(ContactoRadio cr) {
        return this.getQrz().compareTo(cr.getQrz());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.num);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactoRadio other = (ContactoRadio)obj;
        return Objects.equals(this.getQrz() + this.getQra(), other.getQrz() + other.getQra());
    }

    private String capitalizeFirstLetter(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1).toLowerCase();
    }
}

