/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC;

import ModeloQSO_MVC.AdifFile;
import ModeloQSO_MVC.ListContactsForExportXML;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModeloQSO {
    protected static final Logger parentLogger = LogManager.getLogger();
    private Logger logger = parentLogger;
    private static final ModeloQSO modeloQSO = new ModeloQSO();

    private ModeloQSO() {
    }

    public static ModeloQSO getInstance() {
        return modeloQSO;
    }

    public String getEstaciones(String pathFichXml) {
        String xml = new String();
        String xmlAux = null;
        if (new File(pathFichXml).isFile()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(pathFichXml));){
                do {
                    if ((xmlAux = reader.readLine()) == null) continue;
                    xml = xml + xmlAux;
                } while (xmlAux != null);
            }
            catch (Exception er) {
                xml = "<?xml version=\"1.0\" ?><JavaQso><autor>EA4GXR, Celemin 84LRCB (Fernando)</autor><Estacion><qrz>Celemin</qrz><qra>Fernando</qra><qth>Carabanchel (madrid)</qth><locator>IN80DJ</locator><rc></rc><email>84lrcb@gmail.com</email><pobox></pobox></Estacion></JavaQso>";
                this.logger.debug("Excepci\u00f3n al leer fichero, inicializo con algunas estaciones");
            }
        } else {
            xml = "<?xml version=\"1.0\" ?><JavaQso><autor>EA4GXR, Celemin 84LRCB (Fernando)</autor><Estacion><qrz>Celemin</qrz><qra>Fernando</qra><qth>Carabanchel (madrid)</qth><locator>IN80DJ</locator><rc></rc><email>84lrcb@gmail.com</email><pobox></pobox></Estacion></JavaQso>";
            this.logger.debug("El fichero no existe. Inicializado con algunas estaciones");
        }
        this.logger.debug("xml Estaciones = " + xml);
        return xml;
    }

    public String getContactos(String pathFichXml) {
        String xml = new String();
        String xmlAux = null;
        if (new File(pathFichXml).isFile()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(pathFichXml));){
                do {
                    if ((xmlAux = reader.readLine()) == null) continue;
                    xml = xml + xmlAux;
                } while (xmlAux != null);
            }
            catch (Exception er) {
                xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><JavaQso><autor>EA4GXR, Celemin 84LRCB (Fernando)</autor></JavaQso>";
                this.logger.debug("Excepci\u00f3n al leer fichero, Inicializo con valor por defecto");
            }
        } else {
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><JavaQso><autor>EA4GXR, Celemin 84LRCB (Fernando)</autor></JavaQso>";
            this.logger.debug("El fichero no existe. Inicializo con valores por defecto.");
        }
        this.logger.debug("xml Contactos = " + xml);
        return xml;
    }

    public boolean setEstaciones(String xml, String pathFichXml) {
        boolean bl;
        BufferedWriter writer = new BufferedWriter(new FileWriter(pathFichXml));
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            writer.write(xml);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception er) {
                this.logger.debug("Excepci\u00f3n en setEstaciones()");
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public boolean setContactos(String xml, String pathFichXml) {
        boolean bl;
        BufferedWriter writer = new BufferedWriter(new FileWriter(pathFichXml));
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            writer.write(xml);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception er) {
                this.logger.debug("Excepci\u00f3n en setContactos()");
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public boolean setAdifRecords(ListContactsForExportXML lcfex, String pathFichAdif) {
        boolean retorno = false;
        AdifFile adifFile = new AdifFile(lcfex);
        adifFile.cargarRegistrosAdif();
        try {
            retorno = adifFile.escribirAFichero(pathFichAdif);
        }
        catch (Exception e) {
            this.logger.debug("Capturada exception en steAdifRecords");
            retorno = false;
        }
        return retorno;
    }

    public ListContactsForExportXML getAdifRecords(String pathFichAdif) {
        AdifFile adifFile = new AdifFile();
        return adifFile.leerFichero(pathFichAdif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificarNumeroLineasFicheroModelo(File file, int numLines) {
        boolean retorno = true;
        int lines = 0;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            while (reader.readLine() != null) {
                ++lines;
            }
        }
        catch (Exception ex) {
            this.logger.debug("Lanzada excepci\u00f3n al comprobar tama\u00f1o fichero");
            retorno = false;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                this.logger.debug("Lanzada IOException al comprobar tama\u00f1o fichero");
                retorno = false;
            }
        }
        if (lines != numLines) {
            retorno = false;
        }
        return retorno;
    }
}

