/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC.adif;

import ModeloQSO_MVC.adif.ADIFException;
import ModeloQSO_MVC.adif.ADIFField;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ADIFRecord {
    private static final String END_OF_RECORD = "<eor>";
    private List<ADIFField> fields = new ArrayList<ADIFField>();

    public static ADIFRecord read(BufferedReader in) throws ADIFException {
        ADIFRecord record = new ADIFRecord();
        ADIFField field;
        while ((field = ADIFField.read(in)) != null) {
            if ("EOR".equalsIgnoreCase(field.getName())) {
                return record;
            }
            record.add(field);
        }
        return null;
    }

    public ADIFField getField(String name) {
        if (name == null) {
            return null;
        }
        for (ADIFField field : this.fields) {
            if (!name.equalsIgnoreCase(field.getName())) continue;
            return field;
        }
        return null;
    }

    public ADIFField getField(int index) {
        if (index >= this.fields.size()) {
            return null;
        }
        return this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public void add(ADIFField field) {
        this.fields.add(field);
    }

    public void write(BufferedWriter out) throws IOException {
        for (ADIFField field : this.fields) {
            field.write(out);
        }
        out.write(END_OF_RECORD);
        out.newLine();
    }
}

