/*
 * Decompiled with CFR 0.152.
 */
package javaqso;

import ControladorQSO_MVC.ControladorQSO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class JavaQso {
    protected static final Logger parentLogger;
    private Logger logger = parentLogger;
    private static Properties javaqsoProperties;

    public static void main(String[] args) {
        parentLogger.traceEntry();
        String defaultSystemPropertyEncoding = System.getProperty("file.encoding");
        parentLogger.debug("defaultSystemPropertyEncoding: " + defaultSystemPropertyEncoding);
        String charsetdefaultcharset = Charset.defaultCharset().name();
        parentLogger.debug("charsetdefaultcharset: " + charsetdefaultcharset);
        ControladorQSO.getInstance().setSystemFileEncoding(charsetdefaultcharset);
        String userHome = System.getProperty("user.home");
        String fileSep = System.getProperty("file.separator");
        parentLogger.debug("System property userHome: " + userHome);
        JavaQso.leerProperties();
        parentLogger.debug("property pathToJarDirectory: " + javaqsoProperties.getProperty("pathToJarDirectory"));
        ControladorQSO.getInstance().setDirEstaciones(javaqsoProperties.getProperty("pathDirEstacionesRadio", javaqsoProperties.getProperty("pathToJarDirectory") + System.getProperty("file.separator") + ".javaQso"));
        ControladorQSO.getInstance().setFichQsoEstaciones(javaqsoProperties.getProperty("ficheroEstacionesRadio", "javaQsoEstaciones.xml"));
        ControladorQSO.getInstance().setFichQsoContactos(javaqsoProperties.getProperty("ficheroContactosRadio", "javaQsoContactos.xml"));
        ControladorQSO.getInstance().setDirFicherosContest(javaqsoProperties.getProperty("dirFicherosContest", "contest"));
        ControladorQSO.getInstance().setIgnorarEncoding(javaqsoProperties.getProperty("ignorarEncoding", "false"));
        parentLogger.debug("pathDirEstacionesRadio: " + ControladorQSO.getInstance().getDirEstaciones());
        parentLogger.debug("dirFicherosContest: " + ControladorQSO.getInstance().getDirFicherosContest());
        parentLogger.debug("ficheroEstacionesRadio: " + ControladorQSO.getInstance().getFichQsoEstaciones());
        parentLogger.debug("ignorarEncoding: " + ControladorQSO.getInstance().isIgnorarEncoding());
        ControladorQSO.getInstance().startApplication();
        parentLogger.traceExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leerProperties() {
        javaqsoProperties = new Properties();
        FileInputStream input = null;
        try {
            String filename = "javaqso.properties";
            String pathToJar = null;
            try {
                pathToJar = new File(JavaQso.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath();
                parentLogger.debug("pathToJar: " + pathToJar);
                javaqsoProperties.setProperty("pathToJarDirectory", pathToJar);
            }
            catch (URISyntaxException ex) {
                parentLogger.debug("URISyntaxException en leerProperties");
            }
            try {
                input = new FileInputStream(pathToJar + System.getProperty("file.separator") + filename);
            }
            catch (FileNotFoundException ex) {
                input = null;
            }
            if (input != null) {
                javaqsoProperties.load(input);
            } else {
                parentLogger.debug("input es null. No hay fichero javaqso.properties");
            }
        }
        catch (IOException ex) {
            parentLogger.error("failed! ", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    parentLogger.error("failed! ", (Throwable)e);
                }
            }
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        parentLogger = LogManager.getLogger();
    }
}

