#####################################################################
# SelectorDeFrecuencias.ps1
# Version 1.1.2  06/12/2024
#
# Autor:
# EA4GXR  Fernando
# fernando@ea4gxr.es,  ea4gxr@gmail.com
# 
# Colaboradores: 
# EA4GM Antonio 
#  (Gracias por sus aportaciones y gran trabajo de Beta-Tester)
# 
# 2024/11/09
# Pequena interfaz CAT para emisora Yaesu FT991-A
# Ver manual adjunto para condiciones de uso
#####################################################################


# Se puede ejecutar el script con el parmetro -C que visualiza en la consola todas las rdenes que se ejcutan
# La opcin -D genera un fichero de log que sirve para ayudar a solucionar los problemas que puendan aparecer
# Uso:
# PS C:\....\>   .\SelectorDeFrecuencias.ps1 [-D] [-C]

# Windows viene con una politica restrictiva a la hora de ejecutar scripts en powershell.
# Para permitir la ejecucin de scripts hay que ejecutar los siguientes comandos:
# Una sola vez: Ejecutar como administrador el powershell y ejecutar: "Set-ExecutionPolicy Unrestricted"
# Luego ya en una ventana normal, cambiarse al directorio de instalacin y ejecutar: 
#    "Unblock-file SelectorDeFrecuencias.ps1"
# El nombre del ejecutable puede ser SelectorDeFrecuencias_V1.0.0.ps1 (sustituir si es as.)


	
param(
    [Alias("D")]
    [switch]$Debug,
	[Alias("C")]
	[switch]$Commands
)


$script:Version = "1.1.2"

$script:TOTinicial = 180    # Valor del tiempo maximo de transmision (No se lee de la radio)
							# Si el de la radio es menor terminar la transmision

$script:COM = "COM3"      # Puerto creado por el driver de la emisora (Puede variar en su caso)
# En cualquier caso el puerto puede selecinarse desde la aplicacin.
$script:baudRate = 38400  # Velocidad del puerto de la emisora, (Se configura en los menus de la mimsa)
$script:retardoRespuesta = 50  # Milisegundos antes de leer respuesta


# Crear fichero de logs para depuracin (En modo normal solo errores son escritos en l)
$location = Get-Location
$script:logFile = [String] $location + "\SelectorDeFrecuencias.log"
# Creamos fichero de log
"Selector de frecuencias INICIADO: $(Get-Date)" | Out-File -FilePath  $script:logFile  -Force


# Funciones para la generacin de trazas/logs
function Write-Debug {
	param(
		[Parameter(Position=0, ValueFromRemainingArguments)]
		[String[]] $message
	)
	if($Debug) {
		# join me une todas las cadenas con un espacio sin salto de lineas. Ver -join $null
		$message  -join " " | Add-Content -Path $logFile
	}
}

function Write-Command {
	param(
		[Parameter(Position=0, ValueFromRemainingArguments)]
		[String[]] $message
	)
	if($Commands) {
		$message  -join " " | Write-Host
		$message  -join " " | Add-Content -Path $logFile
	} else {
		$message  -join " " | Add-Content -Path $logFile
	}
}

function Write-Error {
	param(
		[Parameter(Position=0, ValueFromRemainingArguments)]
		[String[]] $message
	)
	
	$message  -join " " | Write-Host
	# join me une todas las cadenas con un espacio sin salto de lineas. Ver -join $null
	$message  -join " " | Add-Content -Path $logFile
}



Write-Debug "location: " $location


# Type (Librerias)
Add-Type -AssemblyName System.Windows.Forms
Add-Type -Assembly System.Drawing  # para los botones con iconos

# Variables generales. No modificar si no se sabe lo que se hace.
$script:BandValue = 3
$script:FrequencyValueVfoA = 7000000
$script:FrequencyValueVfoB = 28330000

$script:enPruebas = $false  # para poder probar sin emisora (con puertos virtuales y putty) NO TOCAR
$script:frecsWidth  # Variable array con las frecuencias del filtro width que son dinamicas.
$script:frecsIndex  # Variable array con el codigo que corresponde a la posicin del width 

$script:port 
$script:vfo = "vfoA"
$script:fast = 1  # valor de avance rapido 1 (100hz) 10 (1khz)  50 (5Khz)
$script:forward = $true
$script:tot = $script:TOTinicial
$script:transmiting = $false


# El programa soporta la FT991A y la FT891 de Yaesu
enum ModelosRadio {
	FT991A
	FT891
}

# Para gestionar las diferencias entre FT991A y FT891. Se cambiar esta variable en la version de la FT891
$script:RadioModel = [ModelosRadio]::FT991A
# $script:RadioModel = [ModelosRadio]::FT891

# En caso de emisora compatible sin VHF y UHF las lineas correspondientes no son procesadas
# la banda HF se usa para los espacios entre bandas y la Continua es un valor especial a mantener.
# las frecuencias en hz
$arrayBandas = @(
	[pscustomobject]@{name='160m.';   startFrec=1810000;  stopFrec=1850000;  actualFrec=1810000;    mode=0} #0 LSB
	[pscustomobject]@{name='80m.';    startFrec=3500000;  stopFrec=3800000;  actualFrec=3500000;    mode=0}
	[pscustomobject]@{name='60m.';    startFrec=5351500;  stopFrec=5366500;  actualFrec=5351500;    mode=1} #1 USB
	[pscustomobject]@{name='40m.';    startFrec=7000000;  stopFrec=7200000;  actualFrec=7000000;    mode=0}
	[pscustomobject]@{name='30m.';    startFrec=10100000; stopFrec=10150000; actualFrec=10100000;   mode=2} #2 CW-U
	[pscustomobject]@{name='20m.';    startFrec=14000000; stopFrec=14350000; actualFrec=14000000;   mode=1}
	[pscustomobject]@{name='17m.';    startFrec=18068000; stopFrec=18168000; actualFrec=18068000;   mode=1}
	[pscustomobject]@{name='15m.';    startFrec=21000000; stopFrec=21450000; actualFrec=21000000;   mode=1}
	[pscustomobject]@{name='12m.';    startFrec=24890000; stopFrec=24990000; actualFrec=24890000;   mode=1}
	[pscustomobject]@{name='11m.';    startFrec=26965000; stopFrec=27405000; actualFrec=26965000;   mode=1}
	[pscustomobject]@{name='10m.';    startFrec=28000000; stopFrec=29700000; actualFrec=28000000;   mode=1}
	[pscustomobject]@{name='6m.';     startFrec=50000000; stopFrec=52000000; actualFrec=50000000;   mode=3} #3 FM
)

if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
$arrayBandas += @(
    [pscustomobject]@{name='2m.';     startFrec=144000000;stopFrec=146000000;actualFrec=144000000;  mode=3}
	[pscustomobject]@{name='70cm.';   startFrec=430000000;stopFrec=440000000;actualFrec=430000000;  mode=3}
)
}

$arrayBandas += @(
	[pscustomobject]@{name='HF.';     startFrec=30000;    stopFrec=56000000; actualFrec=30000;      mode=4} #4 AM
)

if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
$arrayBandas += @(
	[pscustomobject]@{name='VHF.';    startFrec=118000000;stopFrec=164000000;actualFrec=118000000;  mode=3}
	[pscustomobject]@{name='UHF.';    startFrec=420000000;stopFrec=470000000;actualFrec=420000000;  mode=3}
)
}

$arrayBandas += @(
	[pscustomobject]@{name='Continua';startFrec=30000;    stopFrec=470000000;actualFrec=530000;     mode=4}
)


# Creacin del objeto formulario (principal)
$script:FrecForm = New-Object Windows.Forms.Form

# Funcin principal del programa 
Function GenerateForm {
    # Main Form and Objects
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	# FORMULARIO Principal
	# $FrecForm = New-Object Windows.Forms.Form
	
	$BandComboPanel = New-Object System.Windows.Forms.Panel
	$BandComboLabel = New-Object System.Windows.Forms.Label
	$BandComboBox = New-Object System.Windows.Forms.ComboBox
	
	
	$FrecTrackPanel = New-Object System.Windows.Forms.Panel
	$FrequencyLabel = New-Object System.Windows.Forms.Label
	$FrequencyTrackBar = New-Object Windows.Forms.TrackBar

	
	# frecuencimetro principal
	$HzLabel = New-Object System.Windows.Forms.Label
	$vfoTiny = New-Object System.Windows.Forms.Label
	$frequencyBoxPanel = New-Object System.Windows.Forms.Panel
	$frequencyBox = New-Object System.Windows.Forms.TextBox
	$EtiquetaTTip = new-Object System.Windows.Forms.ToolTip
	

	$FrecuencimetroVfoB = New-Object System.Windows.Forms.Label
	$LetraFrecGrande = New-Object System.Drawing.Font('Ariel',20,[System.Drawing.FontStyle]::Bold)
	$LetraFrecMediana = New-Object System.Drawing.Font('Ariel',12,[System.Drawing.FontStyle]::Bold)
	
	$GainPanel = New-Object System.Windows.Forms.Panel
	$RFgainLabel = New-Object System.Windows.Forms.Label
	$RFgainTrackBar = New-Object Windows.Forms.TrackBar
	
	
	$AFgainLabel = New-Object System.Windows.Forms.Label
	$AFgainTrackBar = New-Object Windows.Forms.TrackBar
	
	$MicGainLabel = New-Object System.Windows.Forms.Label
	$MicGainTrackBar = New-Object Windows.Forms.TrackBar
	
	$WidthPanel = New-Object System.Windows.Forms.Panel
	$WidthLabel = New-Object System.Windows.Forms.Label
	$WidthTrackBar = New-Object Windows.Forms.TrackBar
	
	$IfShiftPanel = New-Object System.Windows.Forms.Panel
	$IfShiftLabel = New-Object System.Windows.Forms.Label
	$IfShiftTrackBar = New-Object Windows.Forms.TrackBar
	
<#	
	$VddPanel = New-Object System.Windows.Forms.Panel
	$VddLabel  = New-Object System.Windows.Forms.Label
	$VddValueLabel = New-Object System.Windows.Forms.Label
	$LetraVdd = New-Object System.Drawing.Font('Ariel',14,[System.Drawing.FontStyle]::Bold)
#>

	$PowerPanel = New-Object System.Windows.Forms.Panel
	$PowerLabel = New-Object System.Windows.Forms.Label
	$PowerTrackBar = New-Object Windows.Forms.TrackBar
	$PowerValueLabel = New-Object System.Windows.Forms.Label
	$LetraPower = New-Object System.Drawing.Font('Ariel',10,[System.Drawing.FontStyle]::Bold)
	
	$SqlLabel = New-Object System.Windows.Forms.Label
	$SqlTrackBar = New-Object Windows.Forms.TrackBar
	
	# $LineLabel = New-Object System.Windows.Forms.Label
    $QsyButton  = New-Object System.Windows.Forms.Button 
    $ExitButton = New-Object System.Windows.Forms.Button

    $VfoButton  = New-Object System.Windows.Forms.Button
	$AtoBButton  = New-Object System.Windows.Forms.Button
	$SplitButton  = New-Object System.Windows.Forms.Button
	$NarrowButton = New-Object System.Windows.Forms.Button
	
	# $NrButton  = New-Object System.Windows.Forms.Button
	$AmpButton = New-Object System.Windows.Forms.Button
	$AttButton = New-Object System.Windows.Forms.Button
	$DnfButton = New-Object System.Windows.Forms.Button
	
	$MasButton   = New-Object System.Windows.Forms.Button
	$MenosButton = New-Object System.Windows.Forms.Button
	$FastButton  = New-Object System.Windows.Forms.Button
	
	$OnOffButton = New-Object System.Windows.Forms.Button
	
	$SerialPortLabel = New-Object System.Windows.Forms.Label
	$SerialPortComboBox = New-Object System.Windows.Forms.ComboBox
	
	$AGCPanel = New-Object System.Windows.Forms.Panel
	$AGCLabel = New-Object System.Windows.Forms.Label
	$AGCComboBox = New-Object System.Windows.Forms.ComboBox
	
	$ModePanel = New-Object System.Windows.Forms.Panel
	$ModeLabel = New-Object System.Windows.Forms.Label
	$ModeComboBox = New-Object System.Windows.Forms.ComboBox
	
	$NbPanel = New-Object System.Windows.Forms.Panel
	$NbCheck = New-Object System.Windows.Forms.CheckBox
	$NbTrackBar = New-Object Windows.Forms.TrackBar
	
	$NrPanel = New-Object System.Windows.Forms.Panel
	$NrCheck = New-Object System.Windows.Forms.CheckBox
	$NrTrackBar = New-Object Windows.Forms.TrackBar
	
	
	$ContourPanel = New-Object System.Windows.Forms.Panel
	$ContourCheck = New-Object System.Windows.Forms.CheckBox
	$ContourTrackBar = New-Object Windows.Forms.TrackBar
	$ContourLevelTrackBar = New-Object Windows.Forms.TrackBar
	$ContourWidthTrackBar = New-Object Windows.Forms.TrackBar
	$ContourLevelLabel = New-Object System.Windows.Forms.Label
	$ContourWidthLabel = New-Object System.Windows.Forms.Label
	
		
	$ClarPanel = New-Object System.Windows.Forms.Panel
	$ClarCheck = New-Object System.Windows.Forms.CheckBox
	$ClarResetButton = New-Object System.Windows.Forms.Button
	$ClarTrackBar = New-Object Windows.Forms.TrackBar
	
	
	$TunerPanel = New-Object System.Windows.Forms.Panel
	$TunerCheck = New-Object System.Windows.Forms.CheckBox
	$TunerButton = New-Object System.Windows.Forms.Button
	
	$IfNotchPanel = New-Object System.Windows.Forms.Panel
	$IfNotchCheck = New-Object System.Windows.Forms.CheckBox
	$IfNotchTrackBar = New-Object Windows.Forms.TrackBar
	$IfNotchButtonWN = New-Object System.Windows.Forms.Button
	
	
	$PttPanel = New-Object System.Windows.Forms.Panel
	$PttDownButton  = New-Object System.Windows.Forms.Button
	$PttOnOffButton  = New-Object System.Windows.Forms.Button
	$PttTimerLabel = New-Object System.Windows.Forms.Label
	$LetraTimer = New-Object System.Drawing.Font('Ariel',20,[System.Drawing.FontStyle]::Bold)
	
	
	$timer = New-Object System.Windows.Forms.Timer
	$timer.Interval = 1000

	$timerFrec = New-Object System.Windows.Forms.Timer
	$timerFrec.Interval = 200
	
	$timerSplit = New-Object System.Windows.Forms.Timer
	$timerSplit.Interval = 1000
	
	$timerSmiter = New-Object System.Windows.Forms.Timer
	$timerSmiter.Interval = 50
	
	

	$FrecForm.BackColor = [System.Drawing.Color]::GhostWhite
	$FrecForm.FormBorderStyle = "FixedSingle"
	
	$FrecForm.Font = "Ariel"
    $FrecForm.Text = "Selector de frecuencias.  " + "Versin: " + $script:Version
	$FrecForm.size = "1200,575"

	
	
	# Declaramos las variables con las imagenes en modo txt base64 
	$script:Content_MicOff   = $null
	$script:Content_MicOn    = $null
	$script:Content_botonOn  = $null
	$script:Content_botonOff = $null
	AsignarContentBotones
	
	
# Los Smiter grficos no existen en la librera Forms, se componen de dos progressBar una para cada color.
	Class Smiter {
		
		$SmiterPanel;
		$ButtonPB
		$lowPB; 
		$highPB;
		$estado;  # los smiter tienen un boton para poder mostrar distinta informacion
		$value;   # variable para generar el efecto smiter lento Ss (hace la media con el valor anterior)
		
		Smiter() { 
			Write-Debug "Constructor clase base Smiter"

			$this.SmiterPanel = New-Object System.Windows.Forms.Panel
			$this.ButtonPB = New-Object System.Windows.Forms.Button
			$this.lowPB = New-Object System.Windows.Forms.ProgressBar
			$this.highPB = New-Object System.Windows.Forms.ProgressBar
			$this.estado = $false  
			$ThisObject = $this    # para poder usar el callback del click del boton desde la clase. (cosa rara)
			
			$this.ButtonPB.add_Click({$ThisObject.cambiaEstado()}.GetNewClosure()) 
		}	
		
		[Smiter] cambiaEstado() {
			$this.estado = !$this.estado
			Write-Command "estado = " $this.estado
			return $this
		}

		
		# [void]Posicion() {
			# #Redefinir en clases derivadas
			# Write-Command "Posicion en clases base"
		# }
		
		[void] writeValue ([int]$mValue) {
			# $mValue = 105

			$this.lowPB.Value  = [Math]::Min($mValue, $this.lowPB.Maximum) 
			$this.highPB.Value = [Math]::Min([Math]::Max(0, ($mValue - $this.lowPB.Maximum)), $this.highPB.Maximum)
			Write-Debug "lowPB.Value: " $this.lowPB.Value
			Write-Debug "highPB.Value: " $this.highPB.Value
			$this.value = $mValue
		}
	}
	
	Class Smiter96 : Smiter {
		
		Smiter96 () : base () {
			$this.Posicion(1,1,"Label")
			Write-Debug "Constructor clase derivada  9 6"
		}
		
		Smiter96 ([int]$left, [int]$top, [String]$label) : base () {
			$this.Posicion($left, $top, $label)
			Write-Debug "Constructor clase derivada smiter96 left = $left  top=$top"
		}
		
		[void]Posicion([int]$left, [int]$top, [String]$label) {
			Write-Debug "funcion Posicion"
			
			# $this.SmiterPanel.left = 70
			# $this.SmiterPanel.Top    = 490
			$this.SmiterPanel.left = $left
			$this.SmiterPanel.Top    = $top
			$this.SmiterPanel.Width  = 215
			$this.SmiterPanel.Height = 22
			$this.SmiterPanel.BackColor = "Blue"


			$this.ButtonPB.Location = "2,1"
			$this.ButtonPB.Size = "40,20"
			# $this.ButtonPB.Text = "S/PO"
			$this.ButtonPB.Text = $label
			$this.ButtonPB.BackColor = "Orange"

 			$this.lowPB.Location = "45,2"
			$this.lowPB.size = "100,18"
			$this.lowPB.Minimum = 0
			$this.lowPB.Maximum = 9
					#	$this.lowPB.Style = "Continuous" # Estilo sin cuadritos, se podra utilizar.
			$this.lowPB.BackColor = "Green"
			$this.lowPB.ForeColor = "Blue"

			$this.highPB.Location = "144,2"
			$this.highPB.size = "69,18"
			$this.highPB.Minimum = 0 
			$this.highPB.Maximum = 6
			$this.highPB.BackColor = "Green"
			$this.highPB.ForeColor = "Red" 
			
			$script:FrecForm.Controls.Add( $this.SmiterPanel )
			$this.SmiterPanel.Controls.Add($this.ButtonPB)
			$this.SmiterPanel.Controls.Add($this.lowPB)
			$this.SmiterPanel.Controls.Add($this.highPB)
		}
	}
	
	Class Smiter55 : Smiter {
		
		Smiter55 () : base () {
			$this.Posicion(1,1, "Label")
			Write-Debug "Constructor clase derivada smiter55 "
		}
		
		Smiter55 ([int]$left, [int]$top, [String]$label) : base () {
			$this.Posicion($left, $top, $label)
			Write-Debug "Constructor clase derivada smiter55 left = $left  top=$top"
		}
		
		[void]Posicion([int]$left, [int]$top, [String]$label) {
			Write-Debug "funcion Posicion"
			
			# $this.SmiterPanel.left = 70
			# $this.SmiterPanel.Top    = 460
			$this.SmiterPanel.left = $left
			$this.SmiterPanel.Top    = $top
			$this.SmiterPanel.Width  = 215
			$this.SmiterPanel.Height = 22
			$this.SmiterPanel.BackColor = "Blue"


			$this.ButtonPB.Location = "2,1"
			$this.ButtonPB.Size = "40,20"
			# $this.ButtonPB.Text = "ALC"
			$this.ButtonPB.Text = $label
			$this.ButtonPB.BackColor = "Orange"

 			$this.lowPB.Location = "45,2"
			$this.lowPB.size = "83,18"
			$this.lowPB.Minimum = 0
			$this.lowPB.Maximum = 7
					$this.lowPB.step = 1 # no uso steps, pongo el valor instantaneo (es un smiter)
			        # $this.lowPB.Style = "Continuous"
			$this.lowPB.BackColor = "Green"
			$this.lowPB.ForeColor = "Blue"

			$this.highPB.Location = "128,2"
			$this.highPB.size = "85,18"
			$this.highPB.Minimum = 0 
			$this.highPB.Maximum = 7
			$this.highPB.BackColor = "Green"
			$this.highPB.ForeColor = "Red" 
			
			$script:FrecForm.Controls.Add( $this.SmiterPanel )
			$this.SmiterPanel.Controls.Add($this.ButtonPB)
			$this.SmiterPanel.Controls.Add($this.lowPB)
			$this.SmiterPanel.Controls.Add($this.highPB)
		}
	}	


	
	$SmiterS = [Smiter96]::new(70,493, "S")
	$SmiterS.writeValue(15)
	
	
	$SmiterSWR_ALC = [Smiter55]::new(70,460, "SWR")
	$SmiterSWR_ALC.writeValue(14)
	
	
	Function TimerSmiter_Tick()
	{
		$timerSmiter.Stop()  # desactivo el timer porque se puede volver a ejecutar antes de terminar.
		leerDatosSmiters
		$timerSmiter.Start() # lo vuelvo a activar.
	}

	$timerSmiter.Add_Tick({TimerSmiter_Tick})
	
	
	
	
	
	
	
	
	Function leerDatosSmiters {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
 		if($script:transmiting -eq $false) {    # En recepcion vemos valores de Smiter

			$SmiterSWR_ALC.SmiterPanel.Hide()  # En recepcion oculto sl SWR / ALC
			
			# Smiter de Santiago en recepcion
			ejecutarComando "RM1"
			$cadSmiter = leerRespuestaRadio  

			if($null -eq $cadSmiter) {  # Para cuando la radio no responda
				$cadSmiter = [int] (Get-Random -Maximum 255)
			}
			$valueMeter = [int] $cadSmiter
			Write-Debug "valueMeter = " $valueMeter
			                    #0,  1,  2,  3,  4,  5,  6,  7,  8,  9,+10,+20,+30,+40,+50,+60
			$SmiterValuesArr = @(0, 12, 24, 40, 50, 65, 80, 95,112,132,151,171,190,212,235,250)							
			#$SmiterValuesArr = @(0, 17, 34, 51, 68, 85,102,119,136,153,170,187,204,221,238,250)					
			$index = -1
			do { $index++ } while ($SmiterValuesArr[$index] -lt $valueMeter -and $index -lt $SmiterValuesArr.count-1)
			Write-Debug "index = " $index
			if($SmiterS.estado -eq $false) {
				$SmiterS.ButtonPB.Text = "S"
				$SmiterS.writeValue($index)	
			} else {
				$SmiterS.ButtonPB.Text = "Ss"
				Write-command "index = " $index
				Write-command "value = " $SmiterS.value
				Write-command "media = " (($index + $SmiterS.value)/2)
				$SmiterS.writeValue(($index + $SmiterS.value) / 2)	
			}
				
			$SmiterS.writeValue($index)		
			
		} else {  # en transmision vemos roe alc y PO
			Write-Debug "Smiters En transmision "
			$SmiterSWR_ALC.SmiterPanel.Show()
			# $SmiterALC.SmiterPanel.Show()
			if($SmiterSWR_ALC.estado -eq $false) {
				$SmiterSWR_ALC.ButtonPB.Text = "SWR"
				# SWR
				ejecutarComando "RM6"
			
				$cadSWR = leerRespuestaRadio  
				if($null -eq $cadSWR) {  # Para cuando la radio no responda
					$cadSWR = [int] (Get-Random -Maximum 255)
				}
				$valueMeter = [int] $cadSWR
								    #0,1.1,1.3,1.5,1.7,1.9,2.1,2.5,R 3,R 4,R 5,R10,R20,R60,RInfinito
				$SmiterValuesArr = @(0, 25, 35, 50, 60, 70, 80,100,123,173,223,233,240,250,255)
				$index = -1
				do { $index++ } while ($SmiterValuesArr[$index] -lt $valueMeter -and $index -lt $SmiterValuesArr.count-1)
				Write-Debug "index = " $index
			
				$SmiterSWR_ALC.writeValue($index)		
				# fin SWR
			} else {
				$SmiterSWR_ALC.ButtonPB.Text = "ALC"
				# ALC
				ejecutarComando "RM4"
			
				$cadALC = leerRespuestaRadio  
				if($null -eq $cadALC) {  # Para cuando la radio no responda
					$cadALC = [int] (Get-Random -Maximum 255)
				}
				$valueMeter = [int] $cadALC
						        
                                    #0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14							
				$SmiterValuesArr = @(0, 15, 30, 45, 60, 75, 90,105,120,135,150,165,180,200,255)
				$index = -1
				do { $index++ } while ($SmiterValuesArr[$index] -lt $valueMeter -and $index -lt $SmiterValuesArr.count-1)
				Write-Debug "index = " $index
			
				$SmiterSWR_ALC.writeValue($index)		
				# fin ALC	
			}
			
			# Smiter de modulacion PO 
			# PO utiliza el mismo smiter que el Santiago.
			ejecutarComando "RM5"
			$cadPO = leerRespuestaRadio  

			if($null -eq $cadPO) {  # Para cuando la radio no responda
				$cadPO = [int] (Get-Random -Maximum 255)
			}
			$valueMeter = [int] $cadPO
			Write-Debug "valueMeter = " $valueMeter
						        #0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
			$SmiterValuesArr = @(0, 54, 84,102,122,142,155,167,175,196,200,220,230,240,250,255)					
			# $SmiterValuesArr = @(0,  1,  5, 15, 25, 35, 45, 55, 75, 95,110,125,150,200,225,255)
			$index = -1
			do { $index++ } while ($SmiterValuesArr[$index] -lt $valueMeter -and $index -lt $SmiterValuesArr.count-1)
			Write-Debug "index = " $index
			
			$SmiterS.ButtonPB.Text = "PO"
			$SmiterS.writeValue($index)	  # Es el mismo del Santiago
			
			# Fin PO 
		} 
	}
	
	
	
	$frequencyBox.Enabled = $false
	$HzLabel.Enabled = $false
	
	

	$imageMicOn = [System.Drawing.Image]::FromStream([IO.MemoryStream][Convert]::FromBase64String($script:Content_MicOn))
	$imageMicOff = [System.Drawing.Image]::FromStream([IO.MemoryStream][Convert]::FromBase64String($script:Content_MicOff))
	
# inicio PTT Panel	
	
	$PttDownButton.Location = "1,1"
	$PttDownButton.Size = "99,75"
	$PttDownButton.Name = "pttDown"
	$PttDownButton.Image = $imageMicOn
	$PttDownButton.BackColor = "Yellow"
	$PttDownButton.add_MouseDown({
		$script:transmiting = $true
		$PttOnOffButton.Image = $imageMicOff
		$PttOnOffButton.Name = "pttOn"
		# $PttOnOffButton.BackColor = "Red"	
		$PttDownButton.Image = $imageMicOff
		$PttDownButton.BackColor = "Red"
		
		$script:tot = $script:TOTinicial
		$PttTimerLabel.Text = totToTxt
		ejecutarComando "TX1"
	})
	$PttDownButton.add_KeyDown({
		if ($_.KeyCode -eq "Space") {
			$script:transmiting = $true
			$PttOnOffButton.Image = $imageMicOff
			$PttOnOffButton.Name = "pttOn"
			# $PttOnOffButton.BackColor = "Red"	
			$PttDownButton.Image = $imageMicOff
			$PttDownButton.BackColor = "Red"
		
			# El evento se repite mientras esta pulsado el espacio. Solo ejecutamos el comando una vez.
			# Cambiaremos el nombre del boton en el evento up.
			if($PttDownButton.Name -eq "pttDown") {
				$script:tot = $script:TOTinicial
			    $PttTimerLabel.Text = totToTxt
				Write-Debug "SPACE down on PttDownButton"
				ejecutarComando "TX1"
				$PttDownButton.Name = "pttUp"
			}
		}
	})		
	
	$PttDownButton.add_KeyUp({
		if ($_.KeyCode -eq "Space") {
			Write-Debug "SPACE up on PttDownButton"
			$script:transmiting = $false
			$PttOnOffButton.Image = $imageMicOn
			$PttOnOffButton.Name = "pttOff"
			$PttOnOffButton.BackColor = "Green"
			$PttDownButton.Image = $imageMicOn
			$PttDownButton.BackColor = "Yellow"		
				
			$script:tot = $script:TOTinicial
			$PttTimerLabel.Text = totToTxt
			
			$PttDownButton.Name = "pttDown"
			ejecutarComando "TX0"
		}
	})
	
	$PttDownButton.add_MouseUp({
		$script:transmiting = $false
		$PttOnOffButton.Image = $imageMicOn
		$PttOnOffButton.Name = "pttOff"
		$PttOnOffButton.BackColor = "Green"
		$PttDownButton.Image = $imageMicOn
		$PttDownButton.BackColor = "Yellow"		
				
		$script:tot = $script:TOTinicial
		$PttTimerLabel.Text = totToTxt
		ejecutarComando "TX0"
	})
	
	$PttOnOffButton.Location = "100,1"
	$PttOnOffButton.Size = "50,75"
	$PttOnOffButton.Name = "pttOff"
	$PttOnOffButton.Image = $imageMicOn
	$PttOnOffButton.BackColor = "Green"
	$PttOnOffButton.add_Click({ptt_action})
	
	$PttTimerLabel.Location = "160,5"
	$PttTimerLabel.Text = totToTxt
	$PttTimerLabel.Size = "80,60"
	$PttTimerLabel.TextAlign = "MiddleCenter" 
	$PttTimerLabel.Font = $LetraTimer
	
	$PttPanel.Controls.Add($PttDownButton)
	$PttPanel.Controls.Add($PttOnOffButton)
	$PttPanel.Controls.Add($PttTimerLabel)
	$PttPanel.left   = 295
	$PttPanel.Top    = 440
	$PttPanel.Width  = 250
	$PttPanel.Height = 75
	$PttPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($PttPanel)
	$PttDownButton.Enabled = $false
	$PttOnOffButton.Enabled = $false
	


	function ptt_action {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Pulsado boton PTT"

		if( $PttOnOffButton.Name -eq "pttOff") {
			$PttOnOffButton.Image = $imageMicOff
			$PttDownButton.Image = $imageMicOff
			$PttOnOffButton.Name = "pttOn"
			$PttOnOffButton.BackColor = "Red"		
			$script:tot = $script:TOTinicial
			$PttTimerLabel.Text = totToTxt
			$script:transmiting = $true
			ejecutarComando "TX1"
		} else {
			$PttOnOffButton.Image = $imageMicOn
			$PttDownButton.Image = $imageMicOn
			$PttOnOffButton.Name = "pttOff"
			$PttOnOffButton.BackColor = "Green"
			$script:tot = $script:TOTinicial
			$PttTimerLabel.Text = totToTxt
			$script:transmiting = $false
			ejecutarComando "TX0"
		}	
	}
# Fin PTT Panel




# Inicio TUNER Panel
	
	$TunerPanel.left   = 980
	$TunerPanel.Top    = 455
	$TunerPanel.Width  = 90
	$TunerPanel.Height = 60
	$TunerPanel.BorderStyle = "FixedSingle"	
	
	$TunerCheck.Location = "8, 8"
	$TunerCheck.Size = "90,15"
	$TunerCheck.Text = "A.TUNER"
	$TunerCheck.Add_CheckStateChanged({
		if($TunerCheck.Enabled -eq $true) {
			if($TunerCheck.Checked -eq $true) {
				ejecutarComando "AC001"
				$TunerButton.Enabled = $true
			} else {
				ejecutarComando "AC000"
				$TunerButton.Enabled = $false
			}
		} else {
			$TunerButton.Enabled = $false
		}
	})
	$TunerCheck.Enabled = $false
	
	$TunerButton.Location ="8,26" 
	$TunerButton.Size = "75,23"
	$TunerButton.Text = "START" 
	$TunerButton.Name = "TunerStart" 
	$TunerButton.BackColor = "Green"
	$TunerButton.add_Click({tuner_action})
	$TunerButton.Enabled = $false
		
	$TunerPanel.Controls.Add($TunerCheck)
	$TunerPanel.Controls.Add($TunerButton)
	$FrecForm.Controls.Add($TunerPanel)
	
	function tuner_action {
		# Write-Debug "Ejecutando TUNER"
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		if($TunerButton.Enabled -eq $true) {
			ejecutarComando "AC002"
		}
	}
	
	function leerTuner {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name	
		# Write-Debug "Leyendo Antena TUNER"
		ejecutarComando "AC"
		$cadTuner = leerRespuestaRadio
			if($null -eq $cadTuner) {  # Para cuando la radio no responda
				$cadTuner ="000"
			}
		if($cadTuner -eq "001") {
			$TunerCheck.Checked = $true
			$TunerButton.Enabled = $true
		} else {
			$TunerCheck.Checked = $false
			$TunerButton.Enabled = $false
		}		
	}

# Fin TUNER Panel





# Inicio Panel IF NOTCH manual con check activacin, deslizador y boton Narrow / Wide
		
	$IfNotchPanel.left   = 680
	$IfNotchPanel.Top    = 455
	$IfNotchPanel.Width  = 260
	$IfNotchPanel.Height = 60
	
	$IfNotchPanel.BorderStyle = "FixedSingle"

	$IfNotchButtonWN.Location ="8,26" 
	$IfNotchButtonWN.Size = "75,23"
	$IfNotchButtonWN.Text = "WIDE" 
	$IfNotchButtonWN.Name = "InbWN1" 
	$IfNotchButtonWN.BackColor = "Green"
	$IfNotchButtonWN.add_Click({ifnotchWN_action})
	$IfNotchButtonWN.Enabled = $false
	
	$IfNotchCheck.Location = "8, 8"
	$IfNotchCheck.Size = "80,15"
	$IfNotchCheck.Text = "IF NOTCH"
	$IfNotchCheck.Add_CheckStateChanged({
		if($IfNotchCheck.Enabled -eq $true) {
			Write-Debug "IfNotch check modificado "
			if($IfNotchCheck.Checked -eq $true) {
				$IfNotchTrackBar.Enabled = $true
				$IfNotchButtonWN.Enabled = $true
				$comando = "BP00001"
				ejecutarComando $comando
			} else {
				$IfNotchTrackBar.Enabled = $false
				$IfNotchButtonWN.Enabled = $false
				$comando = "BP00000"
				ejecutarComando $comando
			}	
		}	
	})
	$IfNotchCheck.Enabled = $false


    $IfNotchTrackBar.Location = "90,7"
	$IfNotchTrackBar.Orientation = "Horizontal"
    $IfNotchTrackBar.Width = 155
    $IfNotchTrackBar.Height = 40
	$IfNotchTrackBar.TickFrequency = 10
	$IfNotchTrackBar.TickStyle = "Both"
	$IfNotchTrackBar.SetRange(1,320)
	$IfNotchTrackBar.LargeChange = 10
	$IfNotchTrackBar.SmallChange = 1
	$IfNotchTrackBar.Value = 1
	$IfNotchTrackBar.add_ValueChanged({ 
		if($IfNotchTrackBar.Enabled -eq $true) {
			Write-Debug "IfNotch TrackBar modificado "
			Write-Debug "IfNotchTrackBar.Value: " $IfNotchTrackBar.Value

			$EtiquetaTTip.SetToolTip($IfNotchTrackBar, [String]($IfNotchTrackBar.Value * 10) + " hz.")
			$comando = "BP01" + $IfNotchTrackBar.Value.ToString("000")
			Write-Debug "IfNotchTrackBar comando: " $comando
			ejecutarComando $comando
		}	
	})
	$IfNotchTrackBar.add_mouseHover({
		Write-Debug "IfNotchTrackBar add_mouseHover "
		$EtiquetaTTip.SetToolTip($IfNotchTrackBar, [String]($IfNotchTrackBar.Value * 10) + " hz.")
	})
	$IfNotchTrackBar.Enabled = $false


	$IfNotchPanel.Controls.Add($IfNotchCheck)
	$IfNotchPanel.Controls.Add($IfNotchTrackBar)
	$IfNotchPanel.Controls.Add($IfNotchButtonWN)
	$FrecForm.Controls.Add($IfNotchPanel)
	
	function ifnotchWN_action {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Cambiando IF NOTCH N/W"
		if($IfNotchButtonWN.Enabled -eq $true) {
			if($IfNotchButtonWN.Name -eq "InbWN1") {
				$IfNotchButtonWN.Name = "InbWN0"
				$IfNotchButtonWN.Text = "NARROW"
				$IfNotchButtonWN.BackColor = "Red"
				if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
					ejecutarComando "EX1140"
				} else {
					ejecutarComando "EX12040"
				}
			} else {
				$IfNotchButtonWN.Name = "InbWN1"
				$IfNotchButtonWN.Text = "WIDE"
				$IfNotchButtonWN.BackColor = "Green"
				if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
					ejecutarComando "EX1141"
				} else {
					ejecutarComando "EX12041"
				}
			}
		}
	}
	
		
	function leerIFnotch {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo IF NOTCH Check "
		ejecutarComando "BP00"
		$cadNotchOnOff = leerRespuestaRadio 
		
			if($null -eq $cadNotchOnOff) {
				$cadNotchOnOff= "001"  #  1 on 0 off
				Write-Debug "WARNING: problema al leer estdao notchde la radio. Ponemos 00001 on	"
			}
		
		if($cadNotchOnOff -eq "001") {
			Write-Debug " catNotch check on"
			$IfNotchTrackBar.Enabled = $true
			$IfNotchButtonWN.Enabled = $true
			$IfNotchCheck.Checked = $true
		} else {		
			$IfNotchCheck.Checked = $false
			$IfNotchButtonWN.Enabled = $false
			$IfNotchTrackBar.Enabled = $false
		}
				
		ejecutarComando "BP01"  # leer frecuencia notch
		$cadNotchFrec = leerRespuestaRadio 
			if($null -eq $cadNotchFrec) {
				$cadNotchFrec= "020"  # Frec 20 para pruebas
				Write-Debug "WARNING: problema al leer frecuencia Notch la radio. Ponemos 00020 	"
			}
		$IfNotchTrackBar.Value = [int] $cadNotchFrec

		if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
			ejecutarComando "EX114"
		} else {
			ejecutarComando "EX1204"
		}
		$cadNotchAncho = leerRespuestaRadio
			if($null -eq $cadNotchAncho) {
				$cadNotchAncho = "0"  
				Write-Debug "WARNING: problema al leer frecuencia Notch la radio. Ponemos 0"
			}
		if($cadNotchAncho -eq "0") {
			$IfNotchButtonWN.Name = "InbWN0"
			$IfNotchButtonWN.Text = "NARROW"
			$IfNotchButtonWN.BackColor = "Red"
		} else {
			$IfNotchButtonWN.Name = "InbWN1"
			$IfNotchButtonWN.Text = "WIDE"
			$IfNotchButtonWN.BackColor = "Green"
		}

	}
	
# Fin Panel IF NOTCH manual con check activacin y deslizador




# Inicio Panel CONTOUR con check activacin y deslizador
	
	$ContourPanel.left   = 680
	$ContourPanel.Top    = 210
	$ContourPanel.Width  = 260
	$ContourPanel.Height = 155
	$ContourPanel.BorderStyle = "FixedSingle"
	
	$ContourLevelLabel.Location = "50,65"
	$ContourLevelLabel.Size = "40,15"
	$ContourLevelLabel.Text = "Level:"
	
	$ContourWidthLabel.Location = "50,115"
	$ContourWidthLabel.Size = "40,15"
	$ContourWidthLabel.Text = "Width:"
		
	$ContourCheck.Location = "8,18"
	$ContourCheck.Size = "90,15"
	$ContourCheck.Text = "CONTOUR"
	$ContourCheck.Add_CheckStateChanged({
		if($ContourCheck.Enabled -eq $true) {
			Write-Debug "Contour check modificado "
			if($ContourCheck.Checked -eq $true) {
				$ContourTrackBar.Enabled = $true			
				$ContourLevelTrackBar.Enabled = $true
				$ContourWidthTrackBar.Enabled = $true				
				$comando = "CO000001"
				ejecutarComando $comando
			} else {
				$ContourTrackBar.Enabled = $false
				$ContourLevelTrackBar.Enabled = $false
				$ContourWidthTrackBar.Enabled = $false				
				$comando = "CO000000"
				ejecutarComando $comando
			}	
		}	
	})
	$ContourCheck.Enabled = $false
	
    $ContourTrackBar.Location = "90,4"
	$ContourTrackBar.Orientation = "Horizontal"
    $ContourTrackBar.Width = 155
    $ContourTrackBar.Height = 40
	$ContourTrackBar.TickFrequency = 10
	$ContourTrackBar.TickStyle = "Both"
	$ContourTrackBar.SetRange(1,320)
	$ContourTrackBar.LargeChange = 10
	$ContourTrackBar.SmallChange = 1
	$ContourTrackBar.Value = 1
	$ContourTrackBar.add_ValueChanged({ 
		if($ContourTrackBar.Enabled -eq $true) {
			Write-Debug "Contour TrackBar modificado "
			Write-Debug "ContourTrackBar.Value: " $ContourTrackBar.Value
			# $SiftTmp =  [Math]::Round($ContourTrackBar.Value/10, 0)
			# $SiftTmp = $SiftTmp * 10
			$SiftTmp =  $ContourTrackBar.Value
			$SiftTmp = $SiftTmp * 10
			$EtiquetaTTip.SetToolTip($ContourTrackBar, [String] $SiftTmp + " hz.")

			$comando = "CO01" + $SiftTmp.ToString("0000")

			Write-Debug "ContourTrackBar comando: " $comando
			ejecutarComando $comando
		}	
	})
	$ContourTrackBar.add_mouseHover({
		Write-Debug "ContourTrackBar add_mouseHover "
		# SiftTmp =  [Math]::Round($ContourTrackBar.Value/10, 0)
		$SiftTmp =  $ContourTrackBar.Value
		$SiftTmp = $SiftTmp * 10
		$EtiquetaTTip.SetToolTip($ContourTrackBar, [String] $SiftTmp + " hz.") 
	})
	$ContourTrackBar.Enabled = $false


    $ContourLevelTrackBar.Location = "90,54"
	$ContourLevelTrackBar.Orientation = "Horizontal"
    $ContourLevelTrackBar.Width = 155
    $ContourLevelTrackBar.Height = 40
	$ContourLevelTrackBar.TickFrequency = 5
	$ContourLevelTrackBar.TickStyle = "Both"
	$ContourLevelTrackBar.SetRange(-40,20)
	$ContourLevelTrackBar.LargeChange = 10
	$ContourLevelTrackBar.SmallChange = 1
	$ContourLevelTrackBar.Value = 0
	$ContourLevelTrackBar.add_ValueChanged({ 
		if($ContourLevelTrackBar.Enabled -eq $true) {
			Write-Debug "ContourLevelTrackBar modificado "
			Write-Debug "ContourLevelTrackBar.Value: " $ContourLevelTrackBar.Value
			$SiftTmp =  $ContourLevelTrackBar.Value
			$EtiquetaTTip.SetToolTip($ContourLevelTrackBar, $SiftTmp)
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				$comando = "EX112" + $SiftTmp.ToString("+00;-00")
			} else {
				$comando = "EX1202"  + $SiftTmp.ToString("+00;-00")
			}
			Write-Debug "ContourLevelTrackBar comando: " $comando
			ejecutarComando $comando
		}	
	})
	$ContourLevelTrackBar.add_mouseHover({
		Write-Debug "ContourLevelTrackBar add_mouseHover "
		$SiftTmp = $ContourLevelTrackBar.Value
		$EtiquetaTTip.SetToolTip($ContourLevelTrackBar, $SiftTmp) 		
	})
	$ContourLevelTrackBar.Enabled = $false
	

    $ContourWidthTrackBar.Location = "90,104"
	$ContourWidthTrackBar.Orientation = "Horizontal"
    $ContourWidthTrackBar.Width = 155
    $ContourWidthTrackBar.Height = 40
	$ContourWidthTrackBar.TickFrequency = 1
	$ContourWidthTrackBar.TickStyle = "Both"
	$ContourWidthTrackBar.SetRange(1,11)
	$ContourWidthTrackBar.LargeChange = 1
	$ContourWidthTrackBar.SmallChange = 1
	$ContourWidthTrackBar.Value = 1
	$ContourWidthTrackBar.add_ValueChanged({ 
		if($ContourWidthTrackBar.Enabled -eq $true) {
			Write-Debug "ContourWidthTrackBar modificado "
			Write-Debug "ContourWidthTrackBar.Value: " $ContourWidthTrackBar.Value
			$SiftTmp =  $ContourWidthTrackBar.Value
			$EtiquetaTTip.SetToolTip($ContourWidthTrackBar, $SiftTmp)
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				$comando = "EX113" + $SiftTmp.ToString("00")
			} else {
				$comando = "EX1203" + $SiftTmp.ToString("00")
			}
			Write-Debug "ContourWidthTrackBar comando: " $comando
			ejecutarComando $comando
		}	
	})
	$ContourWidthTrackBar.add_mouseHover({
		Write-Debug "ContourWidthTrackBar add_mouseHover "
		$SiftTmp = $ContourWidthTrackBar.Value
		$EtiquetaTTip.SetToolTip($ContourWidthTrackBar, $SiftTmp) 	
	})
	$ContourWidthTrackBar.Enabled = $false


	$ContourPanel.Controls.Add($ContourLevelLabel)
	$ContourPanel.Controls.Add($ContourWidthLabel)
	$ContourPanel.Controls.Add($ContourCheck)
	$ContourPanel.Controls.Add($ContourTrackBar)
	$ContourPanel.Controls.Add($ContourLevelTrackBar)
	$ContourPanel.Controls.Add($ContourWidthTrackBar)
	$FrecForm.Controls.Add($ContourPanel)
	
	function leerContour {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo Contour"
		ejecutarComando "CO00"
		$cadContour = leerRespuestaRadio
			if($null -eq $cadContour) {  # Para cuando la radio no responda
					Write-Debug "WARNING: problema al leer CONTOUR de la radio. Ponemos 0001 "
					$cadContour ="0001"
			}
		if($cadContour -eq "0001") {
			$ContourCheck.Checked = $true
			$ContourTrackBar.Enabled = $true
			$ContourLevelTrackBar.Enabled = $true
			$ContourWidthTrackBar.Enabled = $true
		} else {
			$ContourCheck.Checked = $false
			$ContourTrackBar.Enabled = $false
			$ContourLevelTrackBar.Enabled = $false
			$ContourWidthTrackBar.Enabled = $false
		}		
		
		#leemos los otros deslizadores.
		ejecutarComando "CO01"  # frecuencia contour
		$cadContour = leerRespuestaRadio
			if($null -eq $cadContour) {  # Para cuando la radio no responda
					Write-Debug "WARNING: problema al leer CONTOUR de la radio. Ponemos 0200 "
					$cadContour = "0200"
			}
		$ContourTrackBar.Value = [Math]::Round([int]$cadContour/10, 0)
		
		if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
			ejecutarComando "EX112"  # contour level
		} else {
			ejecutarComando "EX1202"  # contour level
		}
		
		$cadContour = leerRespuestaRadio
			if($null -eq $cadContour) {  # Para cuando la radio no responda
					Write-Debug "WARNING: problema al leer CONTOUR Level de la radio. Ponemos +10 "
					$cadContour = "+10"
			}
		$ContourLevelTrackBar.value = [int] $cadContour
		
		
		if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
			ejecutarComando "EX113"  # contour width
		} else {
			ejecutarComando "EX1203"  # contour width
		}
		$cadContour = leerRespuestaRadio
			if($null -eq $cadContour) {  # Para cuando la radio no responda
				Write-Debug "WARNING: problema al leer CONTOUR Width de la radio. Ponemos 05 "
				$cadContour = "05"
			}
		$ContourWidthTrackBar.value = [int] $cadContour
	}
	
# Fin Panel CONTOUR con check activacin y deslizador




# Inicio Panel CLAR con check activacin y deslizador

	$ClarCheck.Location = "10,8"
	$ClarCheck.Size = "60,15"
	$ClarCheck.Text = "CLAR"
	$ClarCheck.Add_CheckStateChanged({
		if($ClarCheck.Enabled -eq $true) {
			Write-Debug "CLAR check modificado "
			if($ClarCheck.Checked -eq $true) {
				$ClarResetButton.Enabled = $true
				$ClarTrackBar.Enabled = $true
				if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
					$comando = "RT1"
				} else {
					$comando = "CF010"
				}
				ejecutarComando $comando
			} else {
				$ClarResetButton.Enabled = $false
				$ClarTrackBar.Enabled = $false
				if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
					$comando = "RT0"
				} else {
					$comando = "CF000"
				}
				ejecutarComando $comando
			}	
		}	
	})
	$ClarCheck.Enabled = $false
	
	
	$ClarResetButton.Location = "8,30"
    $ClarResetButton.Size = "75,23"
    $ClarResetButton.Text = "RESET"
    $ClarResetButton.add_Click({
		$comando = "RC"
		ejecutarComando $comando
		$ClarTrackBar.Value = 0
	})
    $ClarPanel.Controls.Add($ClarResetButton)
	$ClarResetButton.Enabled = $false
	
	
	$ClarPanel.left   = 105
	$ClarPanel.Top    = 160
	$ClarPanel.Width  = 290
	$ClarPanel.Height = 65
	# $ClarPanel.BackColor = '255,255,0'
	$ClarPanel.BorderStyle = "FixedSingle"


    $ClarTrackBar.Location = "95,10"
	$ClarTrackBar.Orientation = "Horizontal"
    $ClarTrackBar.Width = 185
    $ClarTrackBar.Height = 40
	$ClarTrackBar.TickFrequency = 10
	$ClarTrackBar.TickStyle = "Both"
	$ClarTrackBar.SetRange(-100,100)
	$ClarTrackBar.LargeChange = 10
	$ClarTrackBar.SmallChange = 1
	$ClarTrackBar.Value = 0
	$ClarTrackBar.add_ValueChanged({ 
		if($ClarTrackBar.Enabled -eq $true) {
			Write-Debug "Clar TrackBar modificado "
			Write-Debug "ClarTrackBar.Value: " $ClarTrackBar.Value
			# $SiftTmp =  [Math]::Round($ClarTrackBar.Value/10, 0)
			# $SiftTmp = $SiftTmp * 10
			$SiftTmp = $ClarTrackBar.Value * 10
			
			$EtiquetaTTip.SetToolTip($ClarTrackBar, [String] $SiftTmp + " hz.")
			if($ClarTrackBar.Value -lt 0) { 
				$comando = "RC;RD" + ($SiftTmp * -1).ToString("0000")
			} elseif ($ClarTrackBar.Value -gt 0) {
				$comando = "RC;RU" + $SiftTmp.ToString("0000")
			} else {
				$comando = "RC"
			}
			Write-Debug "ClarTrackBar comando: " $comando
			ejecutarComando $comando
		}	
	})
	$ClarTrackBar.add_mouseHover({
		Write-Debug "ClarTrackBar add_mouseHover "
		# $SiftTmp =  [Math]::Round($ClarTrackBar.Value/10, 0)
		$SiftTmp = $ClarTrackBar.Value
		$SiftTmp = $SiftTmp * 10
		$EtiquetaTTip.SetToolTip($ClarTrackBar, [String] $SiftTmp + " hz.") 
	})
	$ClarTrackBar.Enabled = $false

	$ClarPanel.Controls.Add($ClarCheck)
	$ClarPanel.Controls.Add($ClarTrackBar)
	$FrecForm.Controls.Add($ClarPanel)
		
	function leerCLAR {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo CLAR"
		
		if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
			ejecutarComando "RT"
		} else {
			ejecutarComando "CF0"
		}
		
		$cadClarAux = "1"
		if ($script:RadioModel-eq [ModelosRadio]::FT891) {
			$cadClarAux = "010"
		}
		$cadCLAR = leerRespuestaRadio
			if($null -eq $cadCLAR) {  # Para cuando la radio no responda
				$cadCLAR = $cadClarAux
			}
		if($cadCLAR -eq $cadClarAux) {
			$ClarCheck.Checked = $true
			$ClarTrackBar.Enabled = $true
			$ClarResetButton.Enabled = $true
		} else {
			$ClarCheck.Checked = $false
			$ClarTrackBar.Enabled = $false
			$ClarResetButton.Enabled = $false
		}		
		
		ejecutarComando "RC"
		$ClarTrackBar.Value = 0
	}

# FIN Panel CLAR con check activacin y deslizador





# Inicio Panel NB con check activacin y deslizador

	$NbCheck.Location = "8,18"
	$NbCheck.Size = "50,15"
	$NbCheck.Text = "NB"
	$NbCheck.Add_CheckStateChanged({
		if($NbCheck.Enabled -eq $true) {
			Write-Debug "NB check modificado "
			if($NbCheck.Checked -eq $true) {
				$NbTrackBar.Enabled = $true
				$comando = "NB01"
				ejecutarComando $comando
			} else {
				$NbTrackBar.Enabled = $false
				$comando = "NB00"
				ejecutarComando $comando
			}	
		}	
	})
	$NbCheck.Enabled = $false
	
	$NbPanel.left   = 980
	$NbPanel.Top    = 250
	$NbPanel.Width  = 180
	$NbPanel.Height = 55
	$NbPanel.BorderStyle = "FixedSingle"


    $NbTrackBar.Location = "50,4"
	$NbTrackBar.Orientation = "Horizontal"
    $NbTrackBar.Width = 125
    $NbTrackBar.Height = 40
	$NbTrackBar.TickFrequency = 1
	$NbTrackBar.TickStyle = "Both"
	$NbTrackBar.SetRange(0,10)
	$NbTrackBar.LargeChange = 1
	$NbTrackBar.SmallChange = 1
	$NbTrackBar.Value = 0
	$NbTrackBar.add_ValueChanged({ 
		if($NbTrackBar.Enabled -eq $true) {
			Write-Debug "NB TrackBar modificado "
			$EtiquetaTTip.SetToolTip($NbTrackBar, $NbTrackBar.Value )
			$comando = "NL0" + $NbTrackBar.Value.ToString("000")
			Write-Debug "NbTrackBar comando: " $comando
			ejecutarComando $comando
		}	
	})
	$NbTrackBar.add_mouseHover({
		Write-Debug "NbTrackBar add_mouseHover "
		$EtiquetaTTip.SetToolTip($NbTrackBar, $NbTrackBar.Value ) 
	})
	$NbTrackBar.Enabled = $false

	$NbPanel.Controls.Add($NbCheck)
	$NbPanel.Controls.Add($NbTrackBar)
	$FrecForm.Controls.Add($NbPanel)	
	
	function leerNB {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo NB"
		ejecutarComando "NB0"
		$cadNB = leerRespuestaRadio
		if($null -eq $cadNB) {  # Para cuando la radio no responda
				$cadNB ="00"
			}
		if($cadNB -eq "01") {
			$NbCheck.Checked = $true
			$NbTrackBar.Enabled = $true
		} else {
			$NbCheck.Checked = $false
			$NbTrackBar.Enabled = $false
		}		
		
		# Leemos el nivel del deslizador con NL
		ejecutarComando "NL0"  # frecuencia contour
		$cadNL = leerRespuestaRadio
			if($null -eq $cadNL) {  # Para cuando la radio no responda
				Write-Debug "WARNING: problema al leer NR Level de la radio. Ponemos 005 "
				$cadNL ="005"
			}
		$NbTrackBar.Value = [int] $cadNL
	}
		
# FIN Panel NB con check activacin y deslizador





# Inicio Panel DNR con check activacin y deslizador

	$NrCheck.Location = "8,18"
	$NrCheck.Size = "50,15"
	$NrCheck.Text = "DNR"
	$NrCheck.Add_CheckStateChanged({
		if($NrCheck.Enabled -eq $true) {
			Write-Debug "DNR check modificado "
			if($NrCheck.Checked -eq $true) {
				$NrTrackBar.Enabled = $true
				$comando = "NR01"
				ejecutarComando $comando
			} else {
				$NrTrackBar.Enabled = $false
				$comando = "NR00"
				ejecutarComando $comando
			}
		}
	})	
	$NrCheck.Enabled = $false
	
	$NrPanel.left   = 980
	$NrPanel.Top    = 310
	$NrPanel.Width  = 180
	$NrPanel.Height = 55
	# $NrPanel.BackColor = '255,255,0'
	$NrPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($NrPanel)

    $NrTrackBar.Location = "50,4"
	$NrTrackBar.Orientation = "Horizontal"
    $NrTrackBar.Width = 125
    $NrTrackBar.Height = 40
	$NrTrackBar.TickFrequency = 1
	$NrTrackBar.TickStyle = "Both"
	$NrTrackBar.SetRange(1,15)
	$NrTrackBar.LargeChange = 1
	$NrTrackBar.SmallChange = 1
	$NrTrackBar.Value = 1
	$NrTrackBar.add_ValueChanged({ 
		if($NrTrackBar.Enabled -eq $true) {
			Write-Debug "NR TrackBar modificado "
			$EtiquetaTTip.SetToolTip($NrTrackBar, $NrTrackBar.Value )
			$comando = "RL0" + $NrTrackBar.Value.ToString("00")
			Write-Debug "NrTrackBar comando: " $comando
			ejecutarComando $comando
		}
	})
	$NrTrackBar.add_mouseHover({
		Write-Debug "NrTrackBar add_mouseHover "
		$EtiquetaTTip.SetToolTip($NrTrackBar, $NrTrackBar.Value ) 
	})
	$NrTrackBar.Enabled = $false

	# $NrPanel.Controls.Add($NrLabel)
	$NrPanel.Controls.Add($NrCheck)
	$NrPanel.Controls.Add($NrTrackBar)

	
	function leerNR {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name	
		# Write-Debug "Leyendo DNR  leerNR"
		ejecutarComando "NR0"
		$cadNR = leerRespuestaRadio
		if($null -eq $cadNR) {  # Para cuando la radio no responda
				$cadNR ="01"
			}
		if($cadNR -eq "01") {
			$NrCheck.Checked = $true
			$NrTrackBar.Enabled = $true
		} else {
			$NrCheck.Checked = $false
			$NrTrackBar.Enabled = $false
		}		
		
		# Leemos el nivel del deslizador NR
		
		ejecutarComando "RL0"  
		$cadRL = leerRespuestaRadio
			if($null -eq $cadRL) {  # Para cuando la radio no responda
				Write-Debug "WARNING: problema al leer RL (DNR) Level de la radio. Ponemos 005 "
				$cadRL ="005"
			}
		$NrTrackBar.Value = [int] $cadRL
	}

# Fin Panel DNR con check activacin y deslizador
	
	
	

# INICIO ComboBox AGC

	$AGCPanel.left   = 550
	$AGCPanel.Top    = 160
	$AGCPanel.Width  = 95
	$AGCPanel.Height = 60
	$AGCPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($AGCPanel)		
	
	$AGCLabel.Location = "6,6"
	$AGCLabel.Size = "60,15"
	$AGCLabel.Text = "AGC"
	$AGCPanel.Controls.Add($AGCLabel)
	
	$AGCComboBox.Name ="AGC"
	$AGCComboBox.Location = "8,28"
	$AGCComboBox.Size = "80,20"
	$AGCComboBox.TabIndex = 0
	$AGCComboBox.DropDownStyle = [System.Windows.Forms.ComboBoxStyle]::DropDownList;
	[void] $AGCComboBox.Items.Add("AUTO")
	[void] $AGCComboBox.Items.Add("FAST")
	[void] $AGCComboBox.Items.Add("MID")
	[void] $AGCComboBox.Items.Add("SLOW")
	$AGCComboBox.SelectedIndex = 0
	$AGCComboBox.add_SelectedIndexChanged({
		if($AGCComboBox.Enabled -eq $true){
			Write-Debug "AGC modificado "
			#Este evento lo produce el teclado, no desde otro componente
			$IndexValue = @('4','1','2','3')
			$code = $IndexValue[$AGCComboBox.SelectedIndex]
			$comando = "GT0" + $code
			Write-Debug "AGCComboBox comando: " $comando
			ejecutarComando $comando	
		}
	})
	$AGCPanel.Controls.Add($AGCComboBox)
	$AGCPanel.Enabled = $false
	
	function leerAGC {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo AGC"
		ejecutarComando "GT0"
		$cadAGC = leerRespuestaRadio
			if($null -eq $cadAGC) {  # Para cuando la radio no responda
				$cadAGC ="06"
			}
		Write-Debug "cadAGC: " $cadAGC
		$IndexValue = @('04','01','02','03','05','06')
		
		$i = [array]::indexof($IndexValue, ([int]$cadAGC).ToString("00"))
		Write-Debug "Leyendo AGC de la radio con indexof: " $i
		if($i -lt 0 -or $i -gt 5)
		{
			Write-Error "ERROR Leyendo AGC de la radio con indexof: FUERA DE RANDO " $i
		}
		
		if($i -lt 0 -or $i -gt 3) { $i = 0 }
		$AGCComboBox.SelectedIndex = $i				
	}

# FIN ComboBox AGC





# Inicio ComboBox MODE Panel

	$ModePanel.left   = 550
	$ModePanel.Top    = 90
	$ModePanel.Width  = 95
	$ModePanel.Height = 60
	$ModePanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($ModePanel)	

    $ModeLabel.Location = "5,6"
	$ModeLabel.Size = "60,15"
	$ModeLabel.Text = "MODE"
	$ModePanel.Controls.Add($ModeLabel)

	$ModeComboBox.Name ="Modulacion"
	$ModeComboBox.Location = "6,27"
	
	$ModeComboBox.Size = "80,20"
	
	$ModeComboBox.TabIndex = 0
	$ModeComboBox.DropDownStyle = [System.Windows.Forms.ComboBoxStyle]::DropDownList;
	[void] $ModeComboBox.Items.Add("LSB")
	[void] $ModeComboBox.Items.Add("USB")
	[void] $ModeComboBox.Items.Add("CW-U")
	[void] $ModeComboBox.Items.Add("FM")
	[void] $ModeComboBox.Items.Add("AM")
	[void] $ModeComboBox.Items.Add("RTTY-LSB")
	[void] $ModeComboBox.Items.Add("CW-L")
	[void] $ModeComboBox.Items.Add("DATA-LSB")
	[void] $ModeComboBox.Items.Add("RTTY-USB")
if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
	[void] $ModeComboBox.Items.Add("DATA-FM")
} elseif ($script:RadioModel-eq [ModelosRadio]::FT891) {
	[void] $ModeComboBox.Items.Add("-")
}
	[void] $ModeComboBox.Items.Add("FM-N")
	[void] $ModeComboBox.Items.Add("DATA-USB")
	[void] $ModeComboBox.Items.Add("AM-N")
if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
	[void] $ModeComboBox.Items.Add("C4FM") 
}
	$ModeComboBox.SelectedIndex = 0
	$ModeComboBox.add_SelectedIndexChanged({
		if($ModeComboBox.Enabled -eq $true){
			Write-Debug "Mode Combo box modificado "
			Write-Debug "Modificando el Mode"
			#Este evento lo produce el teclado, no desde otro componente
			$IndexValue = @('1','2','3','4','5','6','7','8','9','A','B','C','D','E')
			$code = $IndexValue[$ModeComboBox.SelectedIndex]
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				$comando = "MD0" + $code
			} else { #FT891
				#Para la 891 hay que seleccionar en los menus. Algo muy extrao.
				# 1107  0:USB 1:LSB para modos 1 y 2
				if($ModeComboBox.SelectedIndex -eq 0) { $comando  = "EX11071;"+"MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 1) { $comando  = "EX11070;"+"MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 3) { $comando  = "MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 4) { $comando  = "MD0" + $code }	
				# 0707  0:USB 1:LSB para modos 3 y 7
				if($ModeComboBox.SelectedIndex -eq 2) { $comando  = "EX07070;"+"MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 6) { $comando  = "EX07071;"+"MD0" + $code }
				# 0812  0:USB 1:LSB para modos 8 y C
				if($ModeComboBox.SelectedIndex -eq 7) { $comando  = "EX08121;"+"MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 11) { $comando = "EX08120;"+"MD0" + $code }
				# 1011  0:USB 1:LSB para modos 6 y 9
				if($ModeComboBox.SelectedIndex -eq 5) { $comando  = "EX10111;"+"MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 8) { $comando  = "EX10110;"+"MD0" + $code }	
				if($ModeComboBox.SelectedIndex -eq 9) { $comando  = "MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 10){ $comando  = "MD0" + $code }
				if($ModeComboBox.SelectedIndex -eq 12){ $comando  = "MD0" + $code }
				
				# TODO me faltan los modos NORMALES....  10 11  13
			}
			Write-Debug "ModeComboBox comando: " $comando
			ejecutarComando $comando	
			setWidthTrackbarValues   # cuando se cambia de modo hay que ajustar el filtro WIDTH
			
			leerPower  # Volver a leer la potencia despues de cambiar el modo
		}		

	})
	$ModePanel.Controls.add($ModeComboBox)
	$ModeComboBox.Enabled = $false
	
	
	
	function leerComboBoxMode {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo MODE"
		ejecutarComando "MD0"
		$cadMode = leerRespuestaRadio
			if($null -eq $cadMode) {  # Para cuando la radio no responda
				$cadMode ="02"
			}
		Write-Debug "cadMode: " $cadMode
		$IndexValue = @('01','02','03','04','05','06','07','08','09','0A','0B','0C','0D','0E')
			
		$i = [array]::indexof($IndexValue, $cadMode)
		Write-Debug "Leyendo MODE de la radio con indexof: " $i
		if($i -lt 0 -or $i -gt $ModeComboBox.Items.Count - 1)
		{
			Write-Error "ERROR Leyendo Mode  de la radio con indexof: FUERA DE RANDO " $i
		}
		
		if($i -lt 0 -or $i -gt $ModeComboBox.Items.Count - 1) { $i = 0 }
		$ModeComboBox.SelectedIndex = $i					
	}


	function setWidthTrackbarValues {
			Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
			$pModeSelected  = $ModeComboBox.SelectedIndex
			$narrow
			if($NarrowButton.Name  -eq "NarrowON") {
				$narrow = $true
			} else {
				$narrow = $false
			}
			
			$WidthTrackBar.Enabled = $true  # cuando voy a poner los valores lo activo
			
			# filtro width depende del modo. Voy a poner a 0 (default) cuando se cambie el modo y ajustar la escala del 
			# deslizador del filtro width
			if($pModeSelected -eq 0 -or $pModeSelected -eq 1) { # SSB
				if($narrow -eq $true) {
					$WidthTrackBar.SetRange(0,9)
					$script:frecsIndex = @('00'      ,'01'     ,'02'     ,'03'     ,'04'     ,'05'      ,'06'      ,'07'      ,'08'      ,'09')
					$script:frecsWidth = @('1500 hz.','200 hz.','400 hz.','600 hz.','850 hz.','1100 hz.','1350 hz.','1500 hz.','1650 hz.','1800 hz.')
				}else {
					$WidthTrackBar.SetRange(0,13)
					$script:frecsIndex = @('00'      ,'09'      ,'10'      ,'11'      ,'12'      ,'13'      ,'14'      ,'15'      ,'16'      ,'17'      ,'18'      ,'19'      ,'20'      ,'21')
					$script:frecsWidth = @('2400 hz.','1800 hz.','1950 hz.','2100 hz.','2200 hz.','2300 hz.','2400 hz.','2500 hz.','2600 hz.','2700 hz.','2800 hz.','2900 hz.','3000 hz.','3200 hz.')
				}
				$WidthTrackBar.Value = 0  # siempre lo pongo por defecto al valor 0 que es el de por defecto de la orden
			} elseif($pModeSelected -eq 2 -or $pModeSelected -eq 6) { # CW
				if($narrow -eq $true) {
					$WidthTrackBar.SetRange(0,10)
					$script:frecsIndex = @('00'     ,'01'    ,'02'     ,'03'     ,'04'     ,'05'     ,'06'     ,'07'     ,'08'     ,'09'     ,'10')
					$script:frecsWidth = @('500 hz.','50 hz.','100 hz.','150 hz.','200 hz.','250 hz.','300 hz.','350 hz.','400 hz.','450 hz.','500 hz.')
				}else {
					$WidthTrackBar.SetRange(0,8)
					$script:frecsIndex = @('00'      ,'10'     ,'11'     ,'12'      ,'13'      ,'14'      ,'15'      ,'16'      ,'17')
					$script:frecsWidth = @('2400 hz.','500 hz.','800 hz.','1200 hz.','1400 hz.','1700 hz.','2000 hz.','2400 hz.','3000 hz.')
				}
				$WidthTrackBar.Value = 0  # siempre lo pongo por defecto al valor 0 que es el de por defecto de la orden
			} elseif($pModeSelected -eq 5 -or $pModeSelected -eq 8) {  # RTTY
				if($narrow -eq $true) {
					$WidthTrackBar.SetRange(0,10)
					$script:frecsIndex = @('00'     ,'01'    ,'02'     ,'03'     ,'04'     ,'05'     ,'06'     ,'07'     ,'08'     ,'09'      ,'10')
					$script:frecsWidth = @('300 hz.','50 hz.','100 hz.','150 hz.','200 hz.','250 hz.','300 hz.','350 hz.','400 hz.','4500 hz.','500 hz.')
				}else {
					$WidthTrackBar.SetRange(0,8)
					$script:frecsIndex = @('00'      ,'10'    ,'11'     ,'12'      ,'13'      ,'14'      ,'15'      ,'16'      ,'17')
					$script:frecsWidth = @('500 hz.','500 hz.','800 hz.','1200 hz.','1400 hz.','1700 hz.','2000 hz.','2400 hz.','3000 hz.')
				}
				$WidthTrackBar.Value = 0  # siempre lo pongo por defecto al valor 0 que es el de por defecto de la orden
			} else {
				# si no esta en estos modos lo deshabilito
				$WidthTrackBar.Enabled = $false
			}
			# $WidthTrackBar.Value = 0  # siempre lo pongo por defecto al valor 0 que es el de por defecto de la orden
			# TODO posible problema con otros modos, lo pongo en cada if.
	}

# FIN ComboBox MODE	
	
	
# Inicio panel DESLIZADOR Frecuencias
	
	# $BandTrackBarValue = 3  # empiezo en la banda de 40 m. por defecto.
	$FrequencyTrackBar.SetRange($arrayBandas[$script:BandValue].startFrec, $arrayBandas[$script:BandValue].stopFrec )
	$FrequencyTrackBarValue = $arrayBandas[$script:BandValue].startFrec
    $FrequencyTrackBar.Value = $FrequencyTrackBarValue 
	
	
	$FrecTrackPanel.left   = 70
	$FrecTrackPanel.Top    = 250
	$FrecTrackPanel.Width  = 375
	$FrecTrackPanel.Height = 90
	$FrecTrackPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($FrecTrackPanel)
	
	$FrequencyLabel.Location = "10,10"
    $FrequencyLabel.Size = "150,23"
    $FrequencyLabel.Text = "Frecuencia: " +  $FrequencyTrackBarValue.ToString('N0')
    $FrecTrackPanel.Controls.Add($FrequencyLabel)


	# QSY Button 
    $QsyButton.Location = "280,5"
    $QsyButton.Size = "75,23"
    $QsyButton.Text = "QSY"
    $QsyButton.add_Click({changeFrecVfo "A" 0})
    $FrecTrackPanel.Controls.Add($QsyButton)
	$QsyButton.Enabled = $false

	
    # Frequency TrackBar
	$FrequencyTrackBar.Location = "10,40"
    $FrequencyTrackBar.Orientation = "Horizontal"
	# $FrequencyTrackBar.BackColor = "Green"
	$FrequencyTrackBar.Width = 350
    $FrequencyTrackBar.Height = 40
	
	$FrequencyTrackBar.TickFrequency = 20000  # distancia entre marcas
	$FrequencyTrackBar.LargeChange = 1000
	$FrequencyTrackBar.SmallChange = 100
    $FrequencyTrackBar.TickStyle = "Both"
	

	$FrequencyTrackBar.add_MouseWheel({
		$m = [System.Windows.Forms.MouseEventArgs]$_
		# number of relative units to move (+/-)
		Write-Debug "Delta = " $m.Delta
		$inc = 100 * $script:fast
		if($m.Delta -lt 0) { 
			$inc = $inc * (-1)
		} 	
		
		# changeFrec($inc)
		$FrequencyTrackBar.Value += $inc
		$FreqTrackBarValue = [Math]::Round($FrequencyTrackBar.Value/100, 0)
		$FreqTrackBarValue = $FreqTrackBarValue * 100
		Write-Debug "FreqTrackBarValue en add_MouseWheel= " $FreqTrackBarValue
		$FrequencyTrackBar.Value = $FreqTrackBarValue
		# $FrequencyTrackBar.Value += 97
	})

    #Frequency TrackBar Event Handler
    $FrequencyTrackBar.add_ValueChanged({
		if($FrequencyTrackBar.Enabled -eq $true) {
			Write-Debug "FrecquencyTrackBar modificado "
			$FreqTmp = [Math]::Round($FrequencyTrackBar.Value/100, 0)
			$FreqTmp = $FreqTmp * 100

			# $arrayBandas[$script:BandValue].actualFrec = $FreqTmp
			$FrequencyLabel.Text = "Frecuencia: " + $FreqTmp.ToString('N0')
			$script:FrequencyValueVfoA = $FreqTmp
			
			Write-Debug "script:FrequencyValueVfoA = " $script:FrequencyValueVfoA
			Write-Debug "FrequencyTrackBar.value = " $FrequencyTrackBar.Value
		}	
    })
    $FrecTrackPanel.Controls.add($FrequencyTrackBar)
    $FrequencyTrackBar.Enabled = $false
	
# Fin panel DESLIZADOR Frecuencias



# INICIO ComboBox BANDA (Reemplazo del trackbar)

	$BandComboPanel.left   = 550
	$BandComboPanel.Top    = 20
	$BandComboPanel.Width  = 95
	$BandComboPanel.Height = 60
	$BandComboPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($BandComboPanel)
	
	$BandComboLabel.Location = "6,6"
	$BandComboLabel.Size = "60,15"
	$BandComboLabel.Text = "BAND"
	$BandComboPanel.Controls.Add($BandComboLabel)

	$BandComboBox.Name ="BAND"
	$BandComboBox.Location = "8,28"
	$BandComboBox.Size = "80,20"
	$BandComboBox.TabIndex = 0
	$BandComboBox.DropDownStyle = [System.Windows.Forms.ComboBoxStyle]::DropDownList;
	# $BandComboBox.SelectedIndex = 0
	$BandComboBox.add_SelectedIndexChanged({
		# Write-Debug "BandComboBox modificado "
		$BandTmp = $BandComboBox.SelectedIndex
		Write-Debug "BandComboBox.SelectedIndex: " $BandTmp
		
		# $script:BandValue = $BandTmp
		$FreqTmpActual = $arrayBandas[$BandTmp].actualFrec
		
		Write-Debug  "arrayBandas[$BandTmp]: " $FreqTmpActual
		Write-Debug  "arrayBandas[$BandTmp].startFrec: " $arrayBandas[$BandTmp].startFrec
		Write-Debug  "arrayBandas[$BandTmp].stopFrec: " $arrayBandas[$BandTmp].stopFrec 
		
		
		
		$FrequencyTrackBar.SetRange($arrayBandas[$BandTmp].startFrec, $arrayBandas[$BandTmp].stopFrec )
		$FrequencyLabel.Text = "Frecuencia: " +  $FreqTmpActual.ToString('N0')
		
		$ModeComboBox.SelectedIndex = $arrayBandas[$BandTmp].mode  # TODO
		# Write-Debug $ModeComboBox.SelectedIndex
		
		$FrequencyTrackBar.Value = $FreqTmpActual
			
		$script:FrequencyValueVfoA = $FreqTmpActual	
		

		
	})
	$BandComboPanel.Controls.Add($BandComboBox)
	$BandComboBox.Enabled = $false

	foreach ($bandTmp in $arrayBandas) {
		# Write-Debug "Banda: " $bandTmp.name
		[void]$BandComboBox.Items.Add($bandTmp.name)
	}
	$BandComboBox.SelectedIndex = 3

    # Read-Host -Prompt "Pulsar una tecla para continuar..."	
	
# FIN ComboBox BANDA




# INICIO SERIAL PORT 

	# Eleccion del puerto serie. Por defecto valor en variable $scrip:COM al inicio script
    $SerialPortLabel.Location = "1080,90"
	$SerialPortLabel.Size = "60,15"
	$SerialPortLabel.Text = "Serial Port:"
	$FrecForm.Controls.Add($SerialPortLabel)

	$SerialPortComboBox.Name ="SerialPort"
	$SerialPortComboBox.Location = "1083,105"
	
	$SerialPortComboBox.Size = "75,23"
	
	$SerialPortComboBox.TabIndex = 0
	$SerialPortComboBox.DropDownStyle = [System.Windows.Forms.ComboBoxStyle]::DropDown;
	[void] $SerialPortComboBox.Items.Add("COM1")
	[void] $SerialPortComboBox.Items.Add("COM2") 
	[void] $SerialPortComboBox.Items.Add("COM3")
	[void] $SerialPortComboBox.Items.Add("COM4")
	[void] $SerialPortComboBox.Items.Add("COM5")
	[void] $SerialPortComboBox.Items.Add("COM6")
	[void] $SerialPortComboBox.Items.Add("COM7")
	[void] $SerialPortComboBox.Items.Add("COM8")
	[void] $SerialPortComboBox.Items.Add("COM9")
	[void] $SerialPortComboBox.Items.Add("COM10")
	[void] $SerialPortComboBox.Items.Add("COM11")
	[void] $SerialPortComboBox.Items.Add("COM12")

	$SerialPortComboBox.SelectedText = $script:COM
	$SerialPortComboBox.add_SelectedIndexChanged({
		Write-Debug "COM port combo modificado "
		$sport = [String] $SerialPortComboBox.SelectedItem
		$script:COM = $sport	
	})
	$FrecForm.Controls.add($SerialPortComboBox)
	$SerialPortComboBox.Enabled = $true

# Fin SERIAL PORT 




# INICIO WIDTH Panel

	$WidthPanel.left   = 980
	$WidthPanel.Top    = 380
	$WidthPanel.Width  = 180
	$WidthPanel.Height = 60
	$WidthPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($WidthPanel)
	
	$WidthLabel.Location = "10,20"
	$WidthLabel.Size = "50,15"
	$WidthLabel.Text = "WIDTH"
	$WidthPanel.Controls.Add($WidthLabel)
	
	$WidthTrackBar.Location = "50,8"
	$WidthTrackBar.Orientation = "Horizontal"
    $WidthTrackBar.Width = 125
    $WidthTrackBar.Height = 40
	$WidthTrackBar.TickFrequency = 1
	$WidthTrackBar.TickStyle = "Both"
	$WidthTrackBar.SetRange(0,21)
	$WidthTrackBar.LargeChange = 1
	$WidthTrackBar.SmallChange = 1
	$WidthTrackBar.Value = 0
	$WidthTrackBar.add_ValueChanged({ 
		$SiftTmp =  $WidthTrackBar.Value
		if($script:frecsWidth -ne $null) {
			$EtiquetaTTip.SetToolTip($WidthTrackBar, $script:frecsWidth[$SiftTmp] )	
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				ejecutarComando ("SH0" + $script:frecsIndex[$WidthTrackBar.Value])
			} else { # FT891
				ejecutarComando ("SH01" + $script:frecsIndex[$WidthTrackBar.Value])
			}
		}	
	})
	$WidthTrackBar.add_mouseHover({
		Write-Debug "$WidthTrackBar add_mouseHover "
		$SiftTmp =  $WidthTrackBar.Value
		if($script:frecsWidth -ne $null) {		
			$EtiquetaTTip.SetToolTip($WidthTrackBar, $script:frecsWidth[$SiftTmp] )
		}
	})
	
	$WidthPanel.Controls.Add($WidthTrackBar)
	$WidthTrackBar.Enabled = $false
	
	function leerWidth {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo WIDTH"
		ejecutarComando "SH0"
		$cadWidth = leerRespuestaRadio 
			if($null -eq $cadWidth) {
				if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
					$cadWidth= "012"
					Write-Debug "WARNING: problema al leer WIDTH de la radio. Ponemos 012	"
				} else { #FT891
					$cadWidth= "0112"
					Write-Debug "WARNING: problema al leer WIDTH de la radio. Ponemos 0112	"
				}
			}	
			
		setWidthTrackbarValues 
		
		if($script:frecsIndex -ne $null) {
			$indexAux = [array]::indexof($script:frecsIndex, ([int]$cadWidth).ToString("00"))
			if($indexAux -gt 0) {
				$WidthTrackBar.Value = $indexAux
			} else {
				$WidthTrackBar.Value = 0
			}
		} else {
			Write-Debug "script:frecsIndex  NULL"
		}
		$WidthTrackBar.Name = $cadWidth		# Tal vez pueda usar el Name para guardar el valor entre llamadas.
	}

# FIN WIDTH Panel




# INICIO IF SHIFT Panel

	$IfShiftPanel.left   = 680
	$IfShiftPanel.Top    = 380
	$IfShiftPanel.Width  = 260
	$IfShiftPanel.Height = 60
	$IfShiftPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($IfShiftPanel)

	$IfShiftLabel.Location = "10,20"
	$IfShiftLabel.Size = "50,15"
	$IfShiftLabel.Text = "IF-Shift"
	# $FrecForm.Controls.Add($IfShiftLabel)
	$IfShiftPanel.Controls.Add($IfShiftLabel)

	$IfShiftTrackBar.Location = "55,8"
	$IfShiftTrackBar.Orientation = "Horizontal"
    $IfShiftTrackBar.Width = 190
    $IfShiftTrackBar.Height = 40
	$IfShiftTrackBar.TickFrequency = 100
	$IfShiftTrackBar.TickStyle = "Both"
	$IfShiftTrackBar.SetRange(-1200,1200)
	$IfShiftTrackBar.LargeChange = 100
	$IfShiftTrackBar.SmallChange = 20
	$IfShiftTrackBar.Value = 0
	$IfShiftTrackBar.add_ValueChanged({ 
		if($IfShiftTrackBar.Enabled -eq $true) {
			Write-Debug "IfShiftTrackBar modificado "
			Write-Debug "IfShiftTrackBar.Value: " $IfShiftTrackBar.Value
			$SiftTmp =  [Math]::Round($IfShiftTrackBar.Value/20, 0)
			$SiftTmp = $SiftTmp * 20
			$EtiquetaTTip.SetToolTip($IfShiftTrackBar, [String] $SiftTmp + " hz." ) 
			# $IfShiftTrackBar.Value = $SiftTmp 
			# $comando = "IS0" + $IfShiftTrackBar.Value.ToString("+0000;-0000")
			# Esto no me dejaba usar el ratn. Ahora el control puede estar un poco desfasado de la emisora.
			
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				$comando = "IS0" + $SiftTmp.ToString("+0000;-0000")
			} else { # FT891
				$comando = "IS01" + $SiftTmp.ToString("+0000;-0000")
			}
			Write-Debug "IfShiftTrackBar comando: " $comando
			ejecutarComando $comando
		}
	})
	$IfShiftTrackBar.add_mouseHover({
		Write-Debug "IfShiftTrackBar add_mouseHover "
		$SiftTmp =  [Math]::Round($IfShiftTrackBar.Value/20, 0)
		$SiftTmp = $SiftTmp * 20
		$EtiquetaTTip.SetToolTip($IfShiftTrackBar, [String] $SiftTmp + " hz." ) 
	})
	
	# $IfShiftTrackBar.add_gotFocus({
		# Write-Debug "IfShiftTrackBar add_gotFocus "
		# # $EtiquetaTTip.SetToolTip($IfShiftTrackBar, $SiftTmp ) # no me saca el tooltip
	# })
	
	$IfShiftPanel.Controls.Add($IfShiftTrackBar)
	$IfShiftTrackBar.Enabled = $false

	function leerIfShift {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo IF SHIFT"
		ejecutarComando "IS0"
		$cadIfShift = leerRespuestaRadio
		Write-Debug "cadIfShift = "  $cadIfShift
		if($null -ne $cadIfShift) {
			if($cadIfShift.Length -gt 2) {#  0-0000 # un cero un signo y cuatro char.
				if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
					$cadIfShift = $cadIfShift.Substring([int]1, $cadIfShift.Length-1) # quitamos un caracter 0 que hay delante del signo
				} else { #FT891
					$cadIfShift = $cadIfShift.Substring([int]2, $cadIfShift.Length-2) # quitamos 2 char 00 o 01
				}		
			} else {
				Write-Error "ERROR: Respuesta incorrecta, pongo valor 0 "
				# formato incorrecto de la respuesta pongo valor 0
				$cadIfShift = "-0000"
			}
		
		}else {  # Para cuando la radio no responda
			$cadIfShift= "-0120"
			Write-Debug "WARNING: problema al leer if-shift de la radio. Ponemos -0120	"	
		}
			
		$IfShiftTrackBar.Value = [int] $cadIfShift
		Write-Debug "IfShiftTrackBar.Value = " $IfShiftTrackBar.Value
	}

# FIN IF SHIFT Panel



<#
# INICIO PANEL VDD


	$VddPanel.left   = 70
	$VddPanel.Top    = 440
	$VddPanel.Width  = 80
	$VddPanel.Height = 75
	$VddPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($VddPanel)
	
	$VddLabel.Location = "6,6"
	$VddLabel.Size = "60,15"
	$VddLabel.Text = "VDD"
	$VddPanel.Controls.Add($VddLabel)
	
	$VddValueLabel.Location = "8,20"
	$VddValueLabel.Size = "60,45"
	$VddValueLabel.Text = "13,8"
	$VddValueLabel.TextAlign = "MiddleCenter" 
	$VddValueLabel.Font = $LetraVdd
	$VddValueLabel.BackColor = "Yellow"
	$VddPanel.Controls.Add($VddValueLabel)
	
	
# FIN PANEL VDD
#>





# INICIO PANEL POWER

	$PowerPanel.left   = 980
	$PowerPanel.Top    = 20
	$PowerPanel.Width  = 75
	$PowerPanel.Height = 220
	$PowerPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($PowerPanel)

	$PowerLabel.Location = "15,7"
	$PowerLabel.Size = "60,15"
	$PowerLabel.Text = "Power"
	$PowerPanel.Controls.Add($PowerLabel)

	$PowerTrackBar.Location = "15,19"
	$PowerTrackBar.Orientation = "Vertical"
    $PowerTrackBar.Width = 40
    $PowerTrackBar.Height = 150
	$PowerTrackBar.TickFrequency = 10
	$PowerTrackBar.TickStyle = "Both"
	$PowerTrackBar.SetRange(5,100)
	$PowerTrackBar.LargeChange = 10
	$PowerTrackBar.SmallChange = 1
	$PowerTrackBar.Value = 5
	$PowerTrackBar.add_ValueChanged({ 
		if($PowerTrackBar.Enabled -eq $true) {
			Write-Debug "Power TrackBack modificado "
			if($PowerTrackBar.Value -lt 26) {
				$PowerValueLabel.BackColor = "Green"
			} elseif ($PowerTrackBar.Value -gt 75) {
				$PowerValueLabel.BackColor = "Red"
			} else {
				$PowerValueLabel.BackColor = "Yellow"
			}
		
			$PowerValueLabel.Text = [String] $PowerTrackBar.Value + "W."
			$comando = "PC" + $PowerTrackBar.Value.ToString("000")
			Write-Debug "PowerTrackBar comando: " $comando
			ejecutarComando $comando
		}
	})
	$PowerPanel.Controls.add($PowerTrackBar)
	$PowerTrackBar.Enabled = $false
	
	$PowerValueLabel.Location = "7,172"
	$PowerValueLabel.Size = "60,40"
	$PowerValueLabel.BorderStyle = "FixedSingle" 
	$PowerValueLabel.TextAlign = "MiddleCenter" 
	$PowerValueLabel.Font = $LetraPower
	$PowerValueLabel.BackColor = "Green"
	$PowerValueLabel.Text = "  5W."
	$PowerPanel.Controls.add($PowerValueLabel)

	function leerPower {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo POTENCIA"
		ejecutarComando "PC"
		$cadPower = leerRespuestaRadio 
		
			if($null -eq $cadPower) {
				$cadPower= "10"
				Write-Debug "WARNING: problema al leer Power de la radio. Ponemos 10	"
			}		
		$PowerTrackBar.Value = [int] $cadPower
		$PowerValueLabel.Text = [String] $PowerTrackBar.Value + "W."	
	}

# FIN PANEL POWER



#inicio PANEL Ganancias

	$GainPanel.left   = 680
	$GainPanel.Top    = 20
	$GainPanel.Width  = 260
	$GainPanel.Height = 170
	$GainPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($GainPanel)

    # INICIO SQL	

	$SqlLabel.Location = "20,10"
    $SqlLabel.Size = "50,15"
    $SqlLabel.Text = "SQL"
    $GainPanel.Controls.Add($SqlLabel)

	$SqlTrackBar.Location = "15,20"
	$SqlTrackBar.Orientation = "Vertical"
    $SqlTrackBar.Width = 50
    $SqlTrackBar.Height = 150
    $SqlTrackBar.TickFrequency = 10
    $SqlTrackBar.TickStyle = "Both"
    $SqlTrackBar.SetRange(0, 100)
    $SqlTrackBar.LargeChange = 10
	$SqlTrackBar.Value = 0
    $SqlTrackBar.add_ValueChanged({ 
		if($SqlTrackBar.Enabled -eq $true) {
			Write-Debug "SQL TrackBack modificado "
			$comando = "SQ0" + $SqlTrackBar.Value.ToString('000')
			$EtiquetaTTip.SetToolTip($SqlTrackBar, $SqlTrackBar.Value )
			Write-Debug "SqlTrackBar comando: " $comando
			ejecutarComando $comando
		}
	})
	$SqlTrackBar.add_mouseHover({
		Write-Debug "SqlTrackBar add_mouseHover "
		$EtiquetaTTip.SetToolTip($SqlTrackBar, $SqlTrackBar.Value ) 
	})
	$GainPanel.Controls.add($SqlTrackBar)
	$SqlTrackBar.Enabled = $false

	function leerSQL {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo SQL"
		ejecutarComando "SQ0"
		$cadSQL = leerRespuestaRadio
			if($null -eq $cadSQL) {  # Para cuando la radio no responda
				$cadSQL= "20"
				Write-Debug "WARNING: problema al leer SQL de la radio. Ponemos 20	"	
			}
		$SqlTrackBar.Value = [int] $cadSQL	
	}
	
	# FIN SQL


	# INICIO AF GAIN	

	$AFgainLabel.Location = "75,10"
    $AFgainLabel.Size = "60,15"
    $AFgainLabel.Text = "AF Gain"
    $GainPanel.Controls.Add($AFgainLabel)

	$AFgainTrackBar.Location = "75,20"
	$AFgainTrackBar.Orientation = "Vertical"
    $AFgainTrackBar.Width = 50
    $AFgainTrackBar.Height = 150
    $AFgainTrackBar.TickFrequency = 25
    $AFgainTrackBar.TickStyle = "Both"
    $AFgainTrackBar.SetRange(0, 255)
    $AFgainTrackBar.LargeChange = 10
	$AFgainTrackBar.Value = 0
    $AFgainTrackBar.add_ValueChanged({ 
		if($AFgainTrackBar.Enabled -eq $true) {
			Write-Debug "AFgain TrackBar modificado "
			$EtiquetaTTip.SetToolTip($AFgainTrackBar, $AFgainTrackBar.Value )
			$comando = "AG0" + $AFgainTrackBar.Value.ToString('000')
			Write-Debug "AFgainTrackBar comando: " $comando
			ejecutarComando $comando
		}	
	})
	$AFgainTrackBar.add_mouseHover({
		Write-Debug "AFgainTrackBar add_mouseHover "
		$EtiquetaTTip.SetToolTip($AFgainTrackBar, $AFgainTrackBar.Value ) 
	})	
	$GainPanel.Controls.add($AFgainTrackBar)
	$AFgainTrackBar.Enabled = $false

	function leerVolumen {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name	
		# Write-Debug "Leyendo VOLUMEN"
		ejecutarComando "AG0"
		$cadVol = leerRespuestaRadio
			
			if($null -eq $cadVol) {  # Para cuando la radio no responda
				$cadVol= "7"
				Write-Debug "WARNING: problema al leer volumen radio. Ponemos 7	"	
			}
		$AFgainTrackBar.Value = [int] $cadVol
	}

	# FIN AF GAIN




	# INICIO RF GAIN
	
	$RFgainLabel.Location = "135,10"
    $RFgainLabel.Size = "60,15"
    $RFgainLabel.Text = "RF Gain"
    $GainPanel.Controls.Add($RFgainLabel)

	$RFgainTrackBar.Location = "135,20"
	$RFgainTrackBar.Orientation = "Vertical"
    $RFgainTrackBar.Width = 50
    $RFgainTrackBar.Height = 150
 
    $RFgainTrackBar.TickStyle = "Both"
	if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
		$RFgainTrackBar.SetRange(0, 255)
		$RFgainTrackBar.TickFrequency = 25
	} else {
		$RFgainTrackBar.SetRange(0, 30)
		$RFgainTrackBar.TickFrequency = 3
	}
    $RFgainTrackBar.LargeChange = 10
    $RFgainTrackBar.Value = 0
    $RFgainTrackBar.add_ValueChanged({
		if($RFgainTrackBar.Enabled -eq $true) {
			Write-Debug "RFgain TrackBar modificado "
			$EtiquetaTTip.SetToolTip($RFgainTrackBar, $RFgainTrackBar.Value )
			$comando = "RG0" + $RFgainTrackBar.Value.ToString('000')
			Write-Debug "RFgainTrackBar comando: " $comando
			ejecutarComando $comando
		}
	})
	$RFgainTrackBar.add_mouseHover({
		Write-Debug "RFgainTrackBar add_mouseHover "
		$EtiquetaTTip.SetToolTip($RFgainTrackBar, $RFgainTrackBar.Value ) 
	})		
	$GainPanel.Controls.add($RFgainTrackBar)
	$RFgainTrackBar.Enabled = $false

	function leerRFgain {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo RF GAIN"
		ejecutarComando "RG0"
		$cadRFgain = leerRespuestaRadio
			
			if($null -eq $cadRFgain) {  # Para cuando la radio no responda
				$cadRFgain= "25"
				Write-Debug "WARNING: problema al leer RF gain de la radio. Ponemos 50	"	
			}
		$RFgainTrackBar.Value = [int] $cadRFgain
	}

	# FIN RF GAIN


	# INICIO MIC GAIN

	$MicGainLabel.Location = "195,10"
    $MicGainLabel.Size = "60,15"
    $MicGainLabel.Text = "Mic Gain"
    $GainPanel.Controls.Add($MicGainLabel)

	$MicGainTrackBar.Location = "195,20"
	$MicGainTrackBar.Orientation = "Vertical"
    $MicGainTrackBar.Width = 50
    $MicGainTrackBar.Height = 150
    $MicGainTrackBar.TickFrequency = 10
    $MicGainTrackBar.TickStyle = "Both"
    $MicGainTrackBar.SetRange(0, 100)
    $MicGainTrackBar.LargeChange = 10
    $MicGainTrackBar.Value = 0
    $MicGainTrackBar.add_ValueChanged({ 
		if($MicGainTrackBar.Enabled -eq $true) {
			Write-Debug "Mic TrackBar modificado "
			$EtiquetaTTip.SetToolTip($MicGainTrackBar, $MicGainTrackBar.Value )
			$comando = "MG" + $MicGainTrackBar.Value.ToString('000')
			Write-Debug "MicGainTrackBar comando: " $comando
			ejecutarComando $comando
		}
	})
	$MicGainTrackBar.add_mouseHover({
		Write-Debug "MicGainTrackBar add_mouseHover "
		$EtiquetaTTip.SetToolTip($MicGainTrackBar, $MicGainTrackBar.Value ) 
	})		
	$GainPanel.Controls.add($MicGainTrackBar)
	$MicGainTrackBar.Enabled = $false

	function leerMicGain {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo MIC GAIN"
		ejecutarComando "MG"
		$cadMicGain = leerRespuestaRadio
			
			if($null -eq $cadMicGain) {  # Para cuando la radio no responda
				$cadMicGain= "50"
				Write-Debug "WARNING: problema al leer Mic gain de la radio. Ponemos 50	"	
			}
		$MicGainTrackBar.Value = [int] $cadMicGain
	}

	# FIN MIC GAIN


#FIN PANEL Ganancias

	
	$image = [System.Drawing.Image]::FromStream([IO.MemoryStream][Convert]::FromBase64String($script:Content_botonOn))


# INICIO ON OF Button
	
	$OnOffButton.Location = "1100,20"
	$OnOffButton.Size = "50,50"
	$OnOffButton.Name = "ON"
	$OnOffButton.Image = $image
	$OnOffButton.add_Click({onOff_action})
	$FrecForm.Controls.Add($OnOffButton)
	
	function onOff_action {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Pulsado Boton ON-OFF"
		
		# Al darle al boton on/off si esta verde se pone rojo, encendemos la emisora y consultamos
		# el estado de todos los controles que tengan estado. Empezando por la frecuencia.
			
		if($OnOffButton.Name -eq "ON") {
			$OnOffButton.Name = "OFF"
			$FechaIniEncendido =  $(Get-Date)
			# Abro el puerto al encender
			$script:port = new-Object System.IO.Ports.SerialPort $script:COM, $script:baudRate, "None", 8, "one"

			$script:port.NewLine = ";"
			$script:port.Handshake = 2
			
			#Retardos para poder probar con puertos virtuales y terminal (putty)
			if($script:enPruebas -eq $true) {
				$script:port.ReadTimeout = 5000
			} else {
				$script:port.ReadTimeout = 100
				$script:port.WriteTimeout = 100
			}
			
			Write-Debug "Estado puerto $script:COM al inicio (True = abierto, False = cerrado): " $script:port.IsOpen
			$script:port.open()
			Write-Debug ($script:port | Format-List | Out-String)  # As veo los atributos del puerto.			
			Write-Debug "Estado puerto $script:COM despues de open (True = abierto, False = cerrado): " $script:port.IsOpen
			
			if($script:port.IsOpen -eq $false) {
				Write-Debug "El puerto que se intenta usar est ocupado o no responde, verifique el valor del Puerto serie"
				$OnOffButton.Name = "ON"
				return
			}
			

			$image = [System.Drawing.Image]::FromStream([IO.MemoryStream][Convert]::FromBase64String($script:Content_botonOff))
			$OnOffButton.Image = $image
			
			# leo los valores con los controles desactivados para poder usar Enabled como control de eventos.
			getFrecRadio
			leerPower
			leerComboBoxMode
			leerVolumen
			leerRFgain
			leerMicGain
			leerIfShift
			leerSQL
			leerNR
			leerNB
			leerATT
			leerAMP 
			leerDNF
			leerCLAR	
			leerIFnotch
			leerContour
			leerSPLIT
			leerNarrow
			leerAGC
			leerWidth
			leerTuner
			
			$SerialPortComboBox.Enabled = $false # cuando se enciende la emisora ya no puede cambiar.	
			
			$frequencyBox.Enabled = $true
			$HzLabel.Enabled = $true
			$FrequencyTrackBar.Enabled = $true
			$BandComboBox.Enabled = $true
			# $BandTrackBar.Enabled  = $true
			$MenosButton.Enabled   = $true
			$MasButton.Enabled = $true
			$VfoButton.Enabled = $true
			$AtoBButton.Enabled = $true
			$QsyButton.Enabled = $true
			$NrCheck.Enabled    = $true
			$AmpButton.Enabled  = $true
			$AttButton.Enabled  = $true
			$DnfButton.Enabled  = $true
			$IfNotchCheck.Enabled = $true
			$RFgainTrackBar.Enabled  = $true
			$AFgainTrackBar.Enabled  = $true
			$MicGainTrackBar.Enabled = $true
			$IfShiftTrackBar.Enabled = $true
			$PowerTrackBar.Enabled   = $true
			$ModeComboBox.Enabled    = $true
			$SqlTrackBar.Enabled     = $true
			$FastButton.Enabled = $true	
			$NbCheck.Enabled = $true
			$PttDownButton.Enabled = $true
			$PttOnOffButton.Enabled = $true
			$FrecuencimetroVfoB.Enabled = $true
			$ClarCheck.Enabled = $true
			$ContourCheck.Enabled = $true
			$SplitButton.Enabled = $true
			$NarrowButton.Enabled = $true
			$AGCPanel.Enabled = $true
			# $WidthTrackBar.Enabled = $true No se activa al inicio. Se activa al cambiar de modo o ancho.
			$TunerCheck.Enabled = $true
			
			$FechaFinEncendido = $(Get-Date)
			
			#Pongo el foco en el PTT
			$FrecForm.ActiveControl = $PttDownButton
			
			
			
			$timerSmiter.Start()
			Write-Command "Selector de frecuencias: Tiempo de encendido: " $(NEW-TIMESPAN -Start $FechaIniEncendido -End $FechaFinEncendido)
		} else {
			$OnOffButton.Name = "ON"
			$timerSmiter.Stop()

			$image = [System.Drawing.Image]::FromStream([IO.MemoryStream][Convert]::FromBase64String($script:Content_botonOn))
			$OnOffButton.Image = $image
			
			$SerialPortComboBox.Enabled = $true  # va a true porque se pone antes de encender la emisora
			
			$frequencyBox.Enabled = $false
			$HzLabel.Enabled = $false
			$FrequencyTrackBar.Enabled = $false
			$BandComboBox.Enabled = $false
			# $BandTrackBar.Enabled  = $false
			$MenosButton.Enabled   = $false
			$MasButton.Enabled = $false
			$VfoButton.Enabled = $false
			$AtoBButton.Enabled = $false
			$QsyButton.Enabled = $false
			$NrCheck.Enabled    = $false
			$NrTrackBar.Enabled = $false
			$AmpButton.Enabled  = $false	
			$AttButton.Enabled  = $false
			$DnfButton.Enabled  = $false
			$IfNotchCheck.Enabled = $false
			$IfNotchTrackBar.Enabled = $false
			$IfNotchButtonWN.Enabled = $false
			$RFgainTrackBar.Enabled  = $false
			$AFgainTrackBar.Enabled  = $false
			$MicGainTrackBar.Enabled = $false
			$IfShiftTrackBar.Enabled = $false
			$PowerTrackBar.Enabled   = $false
			$ModeComboBox.Enabled   = $false
			$SqlTrackBar.Enabled    = $false
			$FastButton.Enabled = $false	
			$NbCheck.Enabled    = $false
			$NbTrackBar.Enabled = $false
			$PttDownButton.Enabled = $false
			$PttOnOffButton.Enabled = $false
			$FrecuencimetroVfoB.Enabled = $false
			$ClarCheck.Enabled = $false
			$ClarTrackBar.Enabled = $false
			$ContourCheck.Enabled = $false
			$ContourTrackBar.Enabled = $false
			$ContourLevelTrackBar.Enabled = $false
			$ContourWidthTrackBar.Enabled = $false
			$SplitButton.Enabled = $false
			$NarrowButton.Enabled = $false
			$AGCPanel.Enabled = $false
			$WidthTrackBar.Enabled = $false
			$TunerCheck.Enabled = $false
				
			# Cierro el puerto al apagar.
			$script:port.close()
			Write-Debug "Estado puerto $script:COM despues de close (True = abierto, False = cerrado): " $script:port.IsOpen	
		}
		Write-Debug "Boton de encendido "  $OnOffButton.Name
	}

# Fin ON OFF Button	
	
	
	
# MAS Button y MENOS Button	

	$MenosButton.Location = "85,40"
	$MenosButton.Size = "23,50"
	$MenosButton.Text = "<"
	$MenosButton.add_Click({changeFrecVfo "A" -100})
	$FrecForm.Controls.Add($MenosButton)
	$MenosButton.Enabled = $false
	
	$timerFrec.Add_Tick({TimerFrec_Tick})
	
	$MenosButton.add_MouseDown({
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$script:forward = $false # signo negativo
		$timerSmiter.Stop()
		$timerFrec.Start()
	})
	$MenosButton.add_MouseUp({
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$timerFrec.Stop()
		$timerSmiter.Start()
	})
	Function TimerFrec_Tick()
	{
		$inc = 100
		if($script:forward -eq $false) {
			$inc = $inc * (-1)
		}		
		Write-Debug "Inc = " $inc
		changeFrecVfo "A" $inc
		
		
		# $SmiterS.writeValue([int] (Get-Random -Maximum 150) )
		
	}
	

	$MasButton.Location = "380,40"
	$MasButton.Size = "23,50"
	$MasButton.Text = ">"
	# $MasButton.DrawBorder([System.Windows.Forms.ButtonBorderStyle] 0) # no hay forma de cambiarlo.
	$MasButton.add_Click({changeFrecVfo "A" 100})
	$FrecForm.Controls.Add($MasButton)
	$MasButton.Enabled = $false

	$MasButton.add_MouseDown({
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$script:forward = $true # signo positivo
		$timerSmiter.Stop()
		$timerFrec.Start()
	})
	$MasButton.add_MouseUp({
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$timerFrec.Stop()
		$timerSmiter.Start()
	})

# Fin MAS MENOS button




# INICIO FAST Button

	$FastButton.Location = "75,115"
	$FastButton.Size = "75,23"
	$FastButton.Text = "< > 100"
	$FastButton.BackColor = "Green"
	$FastButton.Name = "fast0"
	$FastButton.add_Click({changeFast})
	$FrecForm.Controls.Add($FastButton)
	$FastButton.Enabled = $false	


	function changeFast {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		Write-Debug "Cambiando incremento salto frecuencia"
		if($FastButton.Name -eq "fast0") {
			$FastButton.Name = "fast1"
			$FastButton.Text = "<< >> 1000"
			$FastButton.BackColor = "Yellow"
			$script:fast = 10
		} elseif($FastButton.Name -eq "fast1") {
			$FastButton.Name = "fast2"
			$FastButton.Text = "<< >> 5000" 
			$FastButton.BackColor = "Red"
			$script:fast = 50
		}elseif($FastButton.Name -eq "fast2") {
			$FastButton.Name = "fast0"
			$FastButton.Text = "< > 100"
			$FastButton.BackColor = "Green"
			$script:fast = 1
		} else {
			$FastButton.Name = "fast0"
			$FastButton.Text = "< > 100"
			$script:fast = 1
			Write-Debug "WARNING Aqu no debera entrar."
		}
	}

# FIN FAST Button


# INICIO SPLIT Button
    $SplitButton.Location = "420,75"
    $SplitButton.Size = "75,23"
    $SplitButton.Text = "SPLIT OFF"
	$SplitButton.Name = "splitOFF"
	$SplitButton.BackColor = "LightGreen"
    $SplitButton.add_Click({acc_split})
    $FrecForm.Controls.Add($SplitButton)
	$SplitButton.Enabled = $false	


	$timerSplit.Add_Tick({TimerSplit_Tick})
	$SplitButton.add_MouseDown({
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$timerSplit.Start()
	})
	$SplitButton.add_MouseUp({
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$timerSplit.Stop()
	})

	Function TimerSplit_Tick()
	{
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$SplitButton.Text = "SPLIT ON"
		
		$SplitButton.BackColor = "Yellow"
		if ( $SplitButton.Name -ne "splitAUTO") {
			ejecutarComando "QS"
			getFrecRadio
		}
		$SplitButton.Name ="splitAUTO"
		$FrecuencimetroVfoB.BackColor = "Yellow"
		$timerSplit.Stop()  
	}



    Function acc_split {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Haciendo SPLIT"
		if($SplitButton.Name -eq "splitOFF") {
			$SplitButton.Text = "SPLIT ON"
			$SplitButton.Name ="splitON"
			$SplitButton.BackColor = "Red"
			$FrecuencimetroVfoB.BackColor = "Red"
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				ejecutarComando "FT3"
			} else {
				ejecutarComando "ST1"
			}
		} elseif ( $SplitButton.Name -eq "splitAUTO") {
			$SplitButton.Name ="splitON"
		}else {
			$SplitButton.Text = "SPLIT OFF"
			$SplitButton.Name ="splitOFF"
			$SplitButton.BackColor = "LightGreen"
			$FrecuencimetroVfoB.BackColor = "LightGreen"
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				ejecutarComando "FT2"
			} else {
				ejecutarComando "ST0"
			}
		}
		getFrecRadio # si hago split, actualizo las frecuencias de la radio.
	}

	function leerSPLIT {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo VFO en transmision"
		if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
			ejecutarComando "FT"
		} else {
			ejecutarComando "ST"
		}
		$cadSplit = leerRespuestaRadio
		if($null -eq $cadSplit) {  # Para cuando la radio no responda
				$cadSplit ="0"
			}
		if($cadSplit -eq "0") {
			$SplitButton.Text = "SPLIT OFF"
			$SplitButton.Name ="splitOFF"
			$SplitButton.BackColor = "LightGreen"
			$FrecuencimetroVfoB.BackColor = "LightGreen"
		} elseif($cadSplit -eq "1") {
			$SplitButton.Text = "SPLIT ON"
			$SplitButton.Name ="splitON"
			$SplitButton.BackColor = "Red"
			$FrecuencimetroVfoB.BackColor = "Red"
		} else {
			#FT891 el 2es QS
			$SplitButton.Text = "SPLIT AUTO"
			$SplitButton.BackColor = "Yellow"
			$SplitButton.Name ="splitAUTO"
		}
		
	}

# FIN SPLIT Button




# INICIO VFO Button 
    $VfoButton.Location = "420,20"
    $VfoButton.Size = "75,23"
    $VfoButton.Text = "VFO A/B"
	$VfoButton.BackColor = "LightGreen"
	$VfoButton.Name = "vfoA"
    $VfoButton.add_Click({changeVfo})
    $FrecForm.Controls.Add($VfoButton)
	$VfoButton.Enabled = $false	
	
		
	# Cambiar de VFO
	# Problema SV cambia los datos de vfoA a vfob y viceversa pero luego se comporta como vfoA
	# hay que revisar  getFrecRadio y todas donde se comprueba el vfo en que se esta
    Function changeVfo {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Cambiando de VFO"
		if($VfoButton.Name -eq "vfoA") {
			$VfoButton.Text = "VFO A/B"
			$VfoButton.Name ="vfoB"
			# $VfoButton.BackColor = "GreenYellow"
			$frequencyBoxPanel.Enabled = $false
			#$frequencyBoxPanel.BackColor = "GreenYellow"
			#$FrequencyBox.BackColor = "GreenYellow"
			#$HzLabel.BackColor = "GreenYellow"
			$frequencyBoxPanel.Enabled = $true		
			$script:vfo = "vfoB"
			Write-Debug "script:vfo: " $script:vfo
			Write-Debug "Cambiando VFO: "  $VfoButton.Name
			ejecutarComando "SV"	

			getFrecRadio
			leerComboBoxMode
				

		} else {
			$VfoButton.Text = "VFO A/B"
			$VfoButton.Name ="vfoA"
			$VfoButton.BackColor = "LightGreen"
			$frequencyBoxPanel.Enabled = $false
			$frequencyBoxPanel.BackColor = "LightGreen"
			$FrequencyBox.BackColor = "LightGreen"		
			$HzLabel.BackColor = "LightGreen"	
			$frequencyBoxPanel.Enabled = $true
			$script:vfo = "vfoA"
			Write-Debug "script:vfo: " $script:vfo
		    Write-Debug "Cambiando VFO: "  $VfoButton.Name
			ejecutarComando "SV"		
			
			getFrecRadio
			leerComboBoxMode
			
		}
	}
	
# Fin VFO Button
	
	
	
# INICIO A = B Button 
    $AtoBButton.Location = "420,47"
    $AtoBButton.Size = "75,23"
    $AtoBButton.Text = "A = B"
	$AtoBButton.BackColor = "LightGreen"
	$AtoBButton.Name = "vfoA"
    $AtoBButton.add_Click({ChAtoB})
    $FrecForm.Controls.Add($AtoBButton)
	$AtoBButton.Enabled = $false	
	
	
	Function ChAtoB {
		ejecutarComando "AB"
		getFrecRadio
		leerComboBoxMode
	}
	
	
# Fin A = B Button	



	
	
# INICIO Narrow Button
    $NarrowButton.Location = "340,115"
    $NarrowButton.Size = "75,23"
    $NarrowButton.Text = "WIDE"
	$NarrowButton.Name = "NarrowOFF"
	$NarrowButton.BackColor = "Green"
    $NarrowButton.add_Click({acc_narrow})
    $FrecForm.Controls.Add($NarrowButton)
	$NarrowButton.Enabled = $false	

    Function acc_narrow {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Haciendo Narrow"
		if($NarrowButton.Name -eq "NarrowOFF") {
			$NarrowButton.Text = "NARROW"
			$NarrowButton.Name ="NarrowON"
			$NarrowButton.BackColor = "Red"
			ejecutarComando "NA01"
			
		} else {
			$NarrowButton.Text = "WIDE"
			$NarrowButton.Name ="NarrowOFF"
			$NarrowButton.BackColor = "Green"
			ejecutarComando "NA00"
		}
		setWidthTrackbarValues  # Cuando se cambia de ancho hay que ajustar el filtro WIDTH
	}

	function leerNarrow {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo VFO en transmision"
		ejecutarComando "NA0"
		$cadNarrow = leerRespuestaRadio
		if($null -eq $cadNarrow) {  # Para cuando la radio no responda
				$cadNarrow ="00"
			}
		if($cadNarrow -eq "00") {
			Write-Debug "Emisora en modo WIDE"
			$NarrowButton.Text = "WIDE"
			$NarrowButton.Name ="NarrowOFF"
			$NarrowButton.BackColor = "Green"
		} else {
			Write-Debug "Emisora en modo NARROW"
			$NarrowButton.Text = "NARROW"
			$NarrowButton.Name ="NarrowON"
			$NarrowButton.BackColor = "Red"
		}
		setWidthTrackbarValues
	}

# FIN Narrow Button	
	

# Exit Button 
    $ExitButton.Location = "1090,495"
    $ExitButton.Size = "75,23"
    $ExitButton.Text = "Salir"
    $ExitButton.add_Click({$FrecForm.close()})
    $FrecForm.Controls.Add($ExitButton)


# Inicio BOTON AMP

	$AmpButton.Location ="1083,140" 
	$AmpButton.Size = "75,23"
	$AmpButton.Text = "IPO" 
	$AmpButton.Name = "Amp0" 
	$AmpButton.add_Click({amp_action})
	$FrecForm.Controls.Add($AmpButton)
	$AmpButton.Enabled = $false


	function amp_action {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Cambiando AMP"
		if($AmpButton.Enabled -eq $true) {
			if($AmpButton.Name -eq "Amp0") {	
				if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
					$AmpButton.Text = "AMP 1"
					$AmpButton.Name = "Amp1"
				} else {
					$AmpButton.Text = "AMP"
					$AmpButton.Name = "Amp2"  # para saltarme el Amp2
				}
				$AmpButton.BackColor = "Yellow"
				ejecutarComando "PA01"
			} elseif($AmpButton.Name -eq "Amp1") {
				$AmpButton.Name = "Amp2"
				$AmpButton.Text = "AMP 2" 
				$AmpButton.BackColor = "Red"
				ejecutarComando "PA02"
			}elseif($AmpButton.Name -eq "Amp2") {
				$AmpButton.Name = "Amp0"
				$AmpButton.Text = "IPO"
				$AmpButton.BackColor = "Green"
				ejecutarComando "PA00"
			} else {
				$AmpButton.Name = "Amp0"
				$AmpButton.Text = "Amp OFF"
				Write-Debug "WARNING Aqu no debera entrar."
			}
		}
	}


	function leerAMP {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo AMP"
		ejecutarComando "PA0"
		$cadAMP = leerRespuestaRadio
		if($null -eq $cadAMP) {  # Para cuando la radio no responda
				$cadAMP ="01"
			}
		if($cadAMP -eq "02") {
			$AmpButton.Name = "Amp2"
			$AmpButton.Text = "AMP 2"
			$AmpButton.BackColor = "Red"
		} elseif($cadAMP -eq "01") {
			$AmpButton.Name = "Amp1"
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				$AmpButton.Text = "AMP 1" 
			} else {
				$AmpButton.Text = "AMP" 
				$AmpButton.Name = "Amp2"  # para saltarme el Amp2
			}
			$AmpButton.BackColor = "Yellow"

		}elseif($cadAMP -eq "00") {
			$AmpButton.Name = "Amp0"
			$AmpButton.Text = "IPO"
			$AmpButton.BackColor = "Green"

		} else {
			$AmpButton.Name = "Amp0"
			$AmpButton.Text = "IPO"
			Write-Debug "WARNING Aqu no debera entrar."
		}
	}

# Fin BOTON AMP



# Inicio BOTON ATT

	$AttButton.Location ="1083,170" 
	$AttButton.Size = "75,23"
	$AttButton.Text = "ATT OFF" 
	$AttButton.Name = "Att0" 
	$AttButton.add_Click({att_action})
	$FrecForm.Controls.Add($AttButton)
	$AttButton.Enabled = $false


	function att_action {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Cambiando ATT"
		if($AttButton.Enabled -eq $true) {
			if($AttButton.Name -eq "Att0") {
				$AttButton.Name = "Att1"
				$AttButton.Text = "ATT ON"
				$AttButton.BackColor = "Red"
				ejecutarComando "RA01"
			} else {
				$AttButton.Name = "Att0"
				$AttButton.Text = "ATT OFF"
				$AttButton.BackColor = "Green"
				ejecutarComando "RA00"
			}
		}
	}

	function leerATT {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo ATT"
		ejecutarComando "RA0"
		$cadATT = leerRespuestaRadio
		if($null -eq $cadATT) {  # Para cuando la radio no responda
				$cadATT ="01"
			}
		if($cadATT -eq "01") {
			$AttButton.Name = "Att1"
			$AttButton.Text = "ATT ON"
			$AttButton.BackColor = "Red"
		} else {
			$AttButton.Name = "Att0"
			$AttButton.Text = "ATT OFF"
			$AttButton.BackColor = "Green"
		}		
	}

# Fin BOTON ATT





# INICIO DNF button

	$DnfButton.Location ="1083,205" 
	$DnfButton.Size = "75,23"
	$DnfButton.Text = "DNF OFF" 
	$DnfButton.Name = "Dnf0" 
	$DnfButton.add_Click({dnf_action})
	$FrecForm.Controls.Add($DnfButton)
	$DnfButton.Enabled = $false

	function leerDNF {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Leyendo DNF"
		ejecutarComando "BC0"
		$cadDNF = leerRespuestaRadio
		if($null -eq $cadDNF) {  # Para cuando la radio no responda
				$cadDNF ="01"
			}
		if($cadDNF -eq "01") {
			$DnfButton.Name = "Dnf1"
			$DnfButton.Text = "DNF ON"
			$DnfButton.BackColor = "Red"
		} else {
			$DnfButton.Name = "Dnf0"
			$DnfButton.Text = "DNF OFF"
			$DnfButton.BackColor = "Green"
		}		
	}


	function dnf_action {
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Cambiando DNF"
		if($DnfButton.Enabled -eq $true) {
			if($DnfButton.Name -eq "Dnf0") {
				$DnfButton.Name = "Dnf1"
				$DnfButton.Text = "DNF ON"
				$DnfButton.BackColor = "Red"
				ejecutarComando "BC01"
			} else {
				$DnfButton.Name = "Dnf0"
				$DnfButton.Text = "DNF OFF"
				$DnfButton.BackColor = "Green"
				ejecutarComando "BC00"
			}
		}
	}


# FIN DNF button



# INICIO FRECUENCIMETRO VFO_B

	
	$FrecuencimetroVfoB.Location = "165,110"
	$FrecuencimetroVfoB.Size = "160,30"
	$FrecuencimetroVfoB.BorderStyle = "FixedSingle" 
	$FrecuencimetroVfoB.TextAlign = "MiddleCenter" 
	$FrecuencimetroVfoB.Font = $LetraFrecMediana
	$FrecuencimetroVfoB.BackColor = "LightGreen"
	$FrecuencimetroVfoB.Text = "7.000.000 Hz."
	$FrecuencimetroVfoB.add_MouseWheel({
		$m = [System.Windows.Forms.MouseEventArgs]$_
		# number of relative units to move (+/-)
		# Write-Debug "Delta = " $m.Delta
		$inc = 100
		if($m.Delta -lt 0) { $inc = $inc * (-1) }		
		changeFrecVfo "B" $inc
		
	})
	$FrecForm.Controls.Add($FrecuencimetroVfoB)
	$FrecuencimetroVfoB.Enabled = $false

# FIN FRECUENCIMETRO VFO_B

# formtatear con . separadores [string]::Format('{0:N0}',$number)
# depende del idioma del windows. (Get-Culture).NumberFormat.NumberGroupSeparator
# textBox1.Text = string.Format(System.Globalization.CultureInfo.GetCultureInfo("id-ID"), "{0:#,##0.00}", 
# double.Parse(textBox1.Text));
	


# INICIO Panel FRECUENCIMETRO Principal


	$frequencyBoxPanel.left   = 120
	$frequencyBoxPanel.Top    = 20
	$frequencyBoxPanel.Width  = 250
	$frequencyBoxPanel.Height = 80
	$frequencyBoxPanel.BackColor = "LightGreen"
	$frequencyBoxPanel.BorderStyle = "FixedSingle"
	$FrecForm.Controls.Add($frequencyBoxPanel)

	$vfoTiny.Location = "2,2"
	$vfoTiny.Size = "45,15"
	$vfoTiny.Text = "VFO-A"
	$vfoTiny.BackColor = "LightGreen"
	$frequencyBoxPanel.Controls.Add($vfoTiny)


	# panel del frequencyBoxPanel incluye la etiqueta Hz y el textbox frequencyBox.
    $HzLabel.Location = "190,23"
	$HzLabel.Size = "52,31"
	$HzLabel.Text = "Hz."
	$HzLabel.Font = $LetraFrecGrande
	$HzLabel.BackColor = "LightGreen" 

	$frequencyBox.Location = "3,23"
	$frequencyBox.Size = "180,80"
	$frequencyBox.BorderStyle = "FixedSingle" 
	$frequencyBox.Font = $LetraFrecGrande
	$frequencyBox.BackColor =  "LightGreen"  
	$frequencyBox.TextAlign = [System.Windows.forms.HorizontalAlignment]::Right
	$frequencyBox.BorderStyle = [System.Windows.Forms.BorderStyle]::None;
	$frequencyBox.Text =  $FrequencyTrackBarValue.ToString('N0')
	$frequencyBox.add_KeyUp({
		if ($_.KeyCode -eq "Enter") {
			Write-Debug "Entrada FRECUENCIA DIRECTA por teclado"
			$script:FrequencyValueVfoA = [int]( (($frequencyBox.Text.Replace(".", "")).Replace(",","")) )
			# Tengo que redondearlo a 100hz.
			$FreqTmp = [Math]::Round($script:FrequencyValueVfoA/100, 0)
			$FreqTmp = $FreqTmp * 100
			$script:FrequencyValueVfoA = $FreqTmp
			$frequencyBox.Text = $script:FrequencyValueVfoA.ToString('N0')
			# FrecuencimetroVfoB.Text = $script:FrequencyValueVfoA.ToString('N0') + " Hz."
			#TODO el tema de la banda
			# changeFrec 0
			changeFrecVfo "A" 0
		}
	})
	$frequencyBox.add_MouseWheel({
		$m = [System.Windows.Forms.MouseEventArgs]$_
		# number of relative units to move (+/-)
		# Write-Debug "Delta = " $m.Delta
		$inc = 100
		if($m.Delta -lt 0) { $inc = $inc * (-1) }		
		# changeFrec($inc)
		changeFrecVfo "A" $inc
	})
	
	$frequencyBoxPanel.Controls.Add($frequencyBox)
	$frequencyBoxPanel.Controls.Add($HzLabel)

	
# FIN Panel FRECUENCIMETRO Principal	
	
	
# Fucniones auxiliares generales

	function incFrec {
		param (
			[Parameter(Mandatory)]
			[int] $pFrec,
			[Parameter(Mandatory)]
			[int] $pInc = 0
		)
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		Write-Debug "incFrec pFrec: $pfrec pInc: $pInc"
		$frecAux = $pFrec + $pInc
		Write-Debug "incFrec : $frecAux"
		
		if($frecAux -lt 30000){
			$frecAux = 30000
		}
if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
		if($frecAux -gt 56000000 -and $frecAux -lt 118000000) {
			if ($pInc -gt 0){
				$frecAux = 118000000
			} else {
				$frecAux = 56000000
			}
		}
		if($frecAux -gt 164000000 -and $frecAux -lt 420000000) {
			if ($pInc -gt 0){
				$frecAux = 420000000
			} else {
				$frecAux = 164000000
			}
		}
		if($frecAux -gt  470000000 -and $pInc -gt 0){
			$frecAux = 470000000
		}
		
} elseif ($script:RadioModel-eq [ModelosRadio]::FT891) {
		if($frecAux -gt 56000000 -and $pInc -gt 0) {
			$frecAux = 56000000
		}
}		
		
		Write-Debug "incFrec devuelve: $frecAux"
		return $frecAux
	}

	function changeFrecVfo {
		param (
			[Parameter(Mandatory)]
			[String] $pVfo,
			[Parameter(Mandatory)]
			[int] $pInc = 0
		)
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		
		if($pVfo -eq "A") {
			$frecAux = $script:FrequencyValueVfoA 
			$OrdenAux = "FA"
		}else {
			$frecAux = $script:FrequencyValueVfoB
			$OrdenAux = "FB"
		}
		# Write-Debug  "frecAux: " $frecAux 
		$bandaIni = getBanda $frecAux 
		# Write-Debug "bandaIni = " $bandaIni 
		
		$frecAux = incFrec $frecAux ($pInc	* $script:fast)
		# Write-Debug  "frecAux incrementada: " $frecAux 
		$bandaFin = getBanda $frecAux
		# Write-Debug "bandaFin = " $bandaFin
		
		$ordenAux += $frecAux.ToString('000000000')
		ejecutarComando $OrdenAux
		
	
		if($pVfo -eq "A") {
			$script:FrequencyValueVfoA = $frecAux
			$frequencyBox.Text = $script:FrequencyValueVfoA.ToString('N0')
			if($bandaIni -ne $bandaFin) {
				$arrayBandas[$BandaFin].actualFrec = $frecAux
				$FrequencyTrackBar.SetRange($arrayBandas[$BandaFin].startFrec, $arrayBandas[$BandaFin].stopFrec )
				# Write-Debug  "arrayBandas[$BandaFin]: " $frecAux 
				# Write-Debug  "arrayBandas[$BandaFin].startFrec: " $arrayBandas[$BandaFin].startFrec
				# Write-Debug  "arrayBandas[$BandaFin].stopFrec: " $arrayBandas[$BandaFin].stopFrec 
				
				$FrequencyTrackBar.Value =	$frecAux
				$BandComboBox.SelectedIndex = $bandaFin 
				Write-Debug "ModeComboBox.SelectedIndex = " $bandaFin
				# $script:BandValue = $bandaFin
			} else {
				$arrayBandas[$BandaFin].actualFrec = $frecAux
				$BandComboBox.SelectedIndex = $bandaFin  #TODO prueba
			}
		} else {
			$script:FrequencyValueVfoB = $frecAux
			$FrecuencimetroVfoB.Text = $script:FrequencyValueVfoB.ToString('N0') + " Hz."
			# TODO aqui no hay gestion de banda....
		}

		# controlar el mando de la potencia en funcion de la banda
		if($frecAux -gt 52000000) { # En vhf y uhf limitado a 50 W Cambio control de potencia
			if($PowerTrackBar.Value -gt 50) {
				$PowerTrackBar.Value = 50
			}
			$PowerTrackBar.SetRange(5,50)	
		} else {
			$PowerTrackBar.SetRange(5,100)
		}
		# fin controlar mando potencia



	}

	
	# Acciones en la carga del formulario
	Function Form_Load
	{
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		$Frecform.Text = "Timer started"
		$timer.Start()
	}
	
	# Acciones al finalizar el formulario
	$FrecForm.Add_Closing({
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		if ($null -ne $script:port){
			$script:port.close()
		}
		if ($null -ne $timer){
			$timer.Stop()
		}
		if ($null -ne $timerSmiter){
			$timerSmiter.Stop()
		}
	})
	
	# Accin al evento timer cada segundo
	Function Timer_Tick()
	{
		Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
		# Write-Debug "Timer_Tick()"
		# $hora = Get-Date -Format "HH:mm:ss"
		$hora =[DateTime]::UtcNow.ToString('HH:mm:ss')
		$Frecform.Text =  "[" + $hora + " UTC]   " + "Selector de frecuencias.  "  + "Versin: " + $script:Version
		
		if($PttOnOffButton.Name -eq "pttOn")
		{
			$script:tot -= 1
			$PttTimerLabel.Text = totToTxt
		}
			
		if($script:tot -lt 1) {
			$script:tot = $script:TOTinicial
			$PttTimerLabel.Text = totToTxt
			ptt_action
		}
	}
	
	
	$FrecForm.Add_Load({Form_Load})
	$timer.Add_Tick({Timer_Tick})
	
	
    $FrecForm.ShowDialog()| Out-Null
	$FrecForm.Dispose()
}




function totToTxt {
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	# Write-Debug "script:tot: " $script:tot
	$min = [int][Math]::Floor($script:tot / 60)  # division entera
	$sec = [int][Math]::Floor($script:tot % 60)  # resto
	$totTxt = [String] $min + ":" + $sec.ToString("00")
	# Write-Debug "totToTxt: " $totTxt
	$totTxt
}


function ejecutarComando ([Parameter(Mandatory)] [string] $comando)
{
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	try
	{
		$limpiar = $script:port.ReadLine()
		if($limpiar -ne $null) {
			Write-Debug "WARNING: Limpiamos respuesta radio a comandos SET: " $limpiar
		}
	} catch [TimeoutException]{
		# Write-Debug "CAPTURADO Excepcion TIMEOUT leyendo posible respuesta a comandos SET"
	}
	
	$orden = $comando
	$Prefijo = $orden.Substring(0,2)
	if( $prefijo -ne "RM") { # los comandos del smiter no los pinto
		Write-Command "Ejecutando COMANDO: " $orden
	} else {
		Write-Debug "Ejecutando COMANDO: " $orden
	}
	$script:port.WriteLine($orden)
}

# Lee la respueta de la ultima orden enviada a la emisora con ejecutarComando.
function leerRespuestaRadio {
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	try
	{
		Start-Sleep -Milliseconds $script:retardoRespuesta
		$respuestaComando = $script:port.ReadLine()
		
	} catch [TimeoutException]{
		Write-Debug "CAPTURADO Excepcion TIMEOUT al leer respuesa a comando con respuesta necesaria"
	}
	
	Write-Debug "RESPUESTA radio: " $respuestaComando
	
	# voy a quitar el prefijo de la orden y el ; aqui.
	if($null -eq $respuestaComando) {
		$respuestaComando = "00" 
		Write-Debug "ERROR GRAVE: problema al leer respuesta radio.	"	
	}

	if($respuestaComando.Length -gt 2) {
		$Prefijo = $respuestaComando.Substring(0,2)
		# TODO los comandos con dos prefijos...
		if($Prefijo -eq "CO" -or $Prefijo -eq "BP") {
			$respuestaComando = $respuestaComando.Substring([int]4,$respuestaComando.Length-4)	
		} elseif ($Prefijo -eq "RM"){
			$respuestaComando = $respuestaComando.Substring([int]3,$respuestaComando.Length-3)	
		} elseif ($Prefijo -ne "EX") {
			$respuestaComando = $respuestaComando.Substring([int]2,$respuestaComando.Length-2)
		} elseif ($Prefijo -eq "EX") { #Comandos EXtentidos con codigo menu.
		
			if ($script:RadioModel-eq [ModelosRadio]::FT991A) {
				$respuestaComando = $respuestaComando.Substring([int]5,$respuestaComando.Length-5)
			} else {
				$respuestaComando = $respuestaComando.Substring([int]6,$respuestaComando.Length-6)
			}
		} else {
			Write-Debug "RESPUESTA solo con prefijo, sin datos: " $Prefijo
			return $null # Aqui no debera llegar  ;-)
		}
		Write-Debug "RESPUESTA radio sin prefijo:" $respuestaComando
	} else {
		$respuestaComando = $null
		Write-Debug "ERROR el comando de respuesta es incorrecto o no hay respuesta"
	}
	
	return $respuestaComando	
}



function getBanda {
	param (
		[Parameter(Mandatory)]
		[int] $pFrec
		)
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	Write-Debug "Frecuencia en getBanda pFrec: "  $pFrec
	for($i=0; $i -lt $arrayBandas.count; $i++){
		if( ($pFrec -ge $arrayBandas[$i].startFrec -and ($pFrec -le $arrayBandas[$i].stopFrec) ) )
		{
			Write-Debug "Banda: "  $arrayBandas[$i].name
			return $i
		}
	}
	# si estoy fuera de banda pongo la banda continua 
	return $arrayBandas.count -1
}





function leerFrecVfoA {
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	# Write-Debug "Leyendo frecuencia PRINCIPAL vfoA"
	$orden = "FA"
	ejecutarComando $orden
	$frecVFO_A = leerRespuestaRadio
		if($null -eq $frecVFO_A) {  # Para cuando la radio no responda
			$frecVFO_A = "007015000"
			Write-Debug "WARNING: problema al leer frecuencia radio. Ponemos 007015000	"	
		}
	# Write-Debug "frecVFO_A: "  $frecVFO_A
	return $frecVFO_A
}

function leerFrecVfoB {
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	# Write-Debug "Leyendo frecuencia SECUNDARIA vfoB"
	$orden = "FB"
	ejecutarComando $orden
	$frecVFO_B = leerRespuestaRadio
		if($null -eq $frecVFO_B) {  # Para cuando la radio no responda
			$frecVFO_B = "028330000"
			Write-Debug "WARNING: problema al leer frecuencia radio. Ponemos 028330000	"	
		}
	# Write-Debug "frecVFO_B: "  $frecVFO_B
	return $frecVFO_B
}


function getFrecRadio {
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	Write-Debug "getFrecRadio"
	
	$frecTmpVFO_A = leerFrecVfoA
	$frecTmpVFO_B = leerFrecVfoB

	$banda = getBanda $frecTmpVFO_A
	
	$FrequencyTrackBar.SetRange($arrayBandas[$Banda].startFrec, $arrayBandas[$Banda].stopFrec )	
	$FrequencyTrackBar.Value = [int] $frecTmpVFO_A
	$script:FrequencyValueVfoA = [int] $frecTmpVFO_A
	$script:FrequencyValueVfoB = [int] $frecTmpVFO_B
	
	$FrecuencimetroVfoB.Text = ([int]$frecTmpVFO_B).ToString('N0') + " Hz."
	Write-Debug "FrecuencimetroVfoB.Text: " $FrecuencimetroVfoB.Text
	$FrequencyBox.Text = $script:FrequencyValueVfoA.ToString('N0')
	Write-Debug "FrequencyBox.Text: " $FrequencyBox.Text
}


function AsignarContentBotones {
	Write-Debug "Inicio Funcion:" $MyInvocation.MyCommand.Name
	$script:Content_MicOff   = "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
"
	$script:Content_MicOn    = "iVBORw0KGgoAAAANSUhEUgAAACgAAAA8CAYAAAAUufjgAAAA7npUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHjajVFbbsQwCPz3KXoEXvHjOM4mK/UGe/wd27BpKlXqSCYwEBjjdL6+n+lrQKok20rNLWcCrFmTDqfSwj4tk007IZHjO5/04QkBpfjqCps4f4KHzx43b8RRH43C4Q5vuxK9O7/f+V0+yn41cgXKazId/oM3UnFFtuKHK8qtltvVjrhaoF7HtEjeMheDNaFScoNfhaxgn8cQqmWOpxSTgog4SgWa5FRWglWtS6WOY9rB87SWUMhaEAwMSubiCU8JCWjcVuNnp88yf+7m2tEf+M+10hubHHW2SBMc4gAAAYRpQ0NQSUNDIHByb2ZpbGUAAHicfZE9SMNAHMVfU6VFqx3sICKSoTrZRUUcSxWLYKG0FVp1MLn0C5o0JCkujoJrwcGPxaqDi7OuDq6CIPgB4uzgpOgiJf4vLbSI8eC4H+/uPe7eAUKjwlSzJwqommWk4jExm1sVfa/oxyCCGINfYqaeSC9m4Dq+7uHh612EZ7mf+3MMKHmTAR6ROMp0wyLeIJ7dtHTO+8QhVpIU4nPiSYMuSPzIdbnFb5yLDgs8M2RkUvPEIWKx2MVyF7OSoRLPEIcVVaN8IdtihfMWZ7VSY+178hcG8tpKmus0RxHHEhJIQoSMGsqowEKEVo0UEynaj7n4Rxx/klwyucpg5FhAFSokxw/+B7+7NQvTU62kQAzofbHtj3HAtws067b9fWzbzRPA+wxcaR1/tQHMfZJe72jhIyC4DVxcdzR5D7jcAYafdMmQHMlLUygUgPcz+qYcMHQL9K21emvv4/QByFBXyzfAwSEwUaTsdZd3+7t7+/dMu78fgPZyrPg8tGUAAA12aVRYdFhNTDpjb20uYWRvYmUueG1wAAAAAAA8P3hwYWNrZXQgYmVnaW49Iu+7vyIgaWQ9Ilc1TTBNcENlaGlIenJlU3pOVGN6a2M5ZCI/Pgo8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJYTVAgQ29yZSA0LjQuMC1FeGl2MiI+CiA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIKICAgIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiCiAgICB4bWxuczpHSU1QPSJodHRwOi8vd3d3LmdpbXAub3JnL3htcC8iCiAgICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIKICAgIHhtbG5zOnhtcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyIKICAgeG1wTU06RG9jdW1lbnRJRD0iZ2ltcDpkb2NpZDpnaW1wOmU1NDIwZDBhLTcxZjctNDI3NC1iN2YzLTIwOTlmYWE4OWYzMCIKICAgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo5N2I5ZDY0Zi1mYmU3LTQxMjMtOWMwNi0yNzQxYzk4OWY0ZTYiCiAgIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDplMDQ3ZDRkYy1jYjJlLTQ0YzYtOTMwNS0wYzVmZDcxZDI5Y2QiCiAgIEdJTVA6QVBJPSIyLjAiCiAgIEdJTVA6UGxhdGZvcm09IldpbmRvd3MiCiAgIEdJTVA6VGltZVN0YW1wPSIxNzMxNjAxOTkyNzI2MzgzIgogICBHSU1QOlZlcnNpb249IjIuMTAuMzgiCiAgIGRjOkZvcm1hdD0iaW1hZ2UvcG5nIgogICB0aWZmOk9yaWVudGF0aW9uPSIxIgogICB4bXA6Q3JlYXRvclRvb2w9IkdJTVAgMi4xMCIKICAgeG1wOk1ldGFkYXRhRGF0ZT0iMjAyNDoxMToxNFQxNzozMzoxMiswMTowMCIKICAgeG1wOk1vZGlmeURhdGU9IjIwMjQ6MTE6MTRUMTc6MzM6MTIrMDE6MDAiPgogICA8eG1wTU06SGlzdG9yeT4KICAgIDxyZGY6U2VxPgogICAgIDxyZGY6bGkKICAgICAgc3RFdnQ6YWN0aW9uPSJzYXZlZCIKICAgICAgc3RFdnQ6Y2hhbmdlZD0iLyIKICAgICAgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDoxY2JlYTdmNy1kNWM2LTQzYjctOWVjYy1iNTE4MTcxMDJkN2YiCiAgICAgIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkdpbXAgMi4xMCAoV2luZG93cykiCiAgICAgIHN0RXZ0OndoZW49IjIwMjQtMTEtMTRUMTc6MzM6MTIiLz4KICAgIDwvcmRmOlNlcT4KICAgPC94bXBNTTpIaXN0b3J5PgogIDwvcmRmOkRlc2NyaXB0aW9uPgogPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgIAo8P3hwYWNrZXQgZW5kPSJ3Ij8+wtICUgAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB+gLDhAhDDjDj9UAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAMHElEQVRo3u2Ze0xb99nHn985vnFsMBAbGwK2MbYRxOXyAmlD3DQdhOa2pSnR3l7UN3kvi6JOiUSlTtFUtdLa7X0TpdG0vm+rZFOldFumKdzWrGtoGRmlXPJyC9gGAjHY2K6PDb5jm3N8LvtjpVqWdIWNdNOW57+j8+j8Pud3ntvvewAe2D+4ob/2ARcuXECJRAJDCAlmZmYgmUhCTW0NbNmyhUulUszx48f5vwngmTNncLfbnZ2RkWEWCARfoyjq8ZmZmazV1CpUVFZwKpVqLBaLdTIMM/LII4+Em5ubqa8M8MKFC1ljY2O7vF7vN0Oh0IFbt27lhkKhz+/zPA/Z2dlgNBpXCwsLe4xG46/y8/N/1dLS4r/vgI8//nimWCw+EY1Gv72wsKAlSfLP+m/ZsgUMBkMwOzv7p1Kp9H/a29s3BIlvxPmNN96QWa3Wb01PT3/X4XDkx+NxUCgUXElJycrOnTv9Dz/8sF2v189UV1djIpEIMAwTLy0tIZIkiXA4XInjuPzpp58eHhwcTK53TcF6HYeHhwUdHR3/EY1GXyVJUo4QgvLy8tW6urober3+Xa1We8NsNpMkSVIUReVPTU09FIlEjnV3dz/qcDiyl5eXMyQSyX+urKykP/roo1f27NkT21TA/v7+yps3bx6fm5uTAwCUlZUlGhoa3tXpdD9oaWnxIoT+OFvnAGCutbX1Y5qmj8pkstMDAwMKn88nnpmZ+deBgYHfAUDnetbF1uP03nvvCWZmZvY7HI5imqahsLCQNZlMv8zJyfneiy++6PkTuM/tyJEjy0VFRT8uKir6P4PBkGRZFm7fvq202+3fuHjxomzTAMPhcF4oFHo0GAxmYBgGWq3WaTAY3q2srPzSgH/ppZdi1dXVl/V6/QRBEOD3+3GGYXYyDFO+aYAzMzO5Pp9PGYlEkEql4ouKiqxVVVX2p556al1F2Gg0OkpKSgYKCwtphmHA5XLlTU9Pb+V5Hm0KoMFgKNFoNHqGYUAoFNIsy95KJBKh9cbv4cOHWb/ff5Om6QQAgEAgkOl0urKFhQXxpgByHEdgGJYBACCVSpFarUYFBQUbqp9KpRIIggAAAJZl8VQqlUGS5ObsIMuyPMdxf6jsCAGGYSAQCDbcgRBCgBACnueBZVmeZdnNicG/pT0AfAD4APAB4D874B3tYHx8PPvNN99UGo3G1b179/qqq6uZrwLC7Xaj9vZ21djYWNbhw4djTz75JHkXYE9PT05ra+vLIyMj9eFwOIZh2LlPPvmkx2KxsPcTLpFIoHfeeeehkZGRlycmJjRyuXyura3tlebm5oU7ANva2oqGh4cPTk1NmVZWVviqqip/NBodAYDw2kntjtjANic6pqamJPF4/OtTU1OH7Ha7iOM4HUmSlwHgTsCxsTHM6XRiDMPAysoKoiiqIBwOiz4bjwDH8bXJBtLpNKwND+s1nufR2ktiGAYikQgkEgksLy8LUqmUMpFICFmWBZfLhVEUhd+VJEajkVepVIBhGKRSKZifn0e3bt0CAAChUBjjeT4GAJBMJrGVlZUsqVQq2lA2YlgOwzBCnucBx/G0RCIJ63Q61mq1gtPpxGKxGCCEQK1Ww7Zt2+7O4kOHDnFlZWWcWCyGeDwO0WhUTRCEAgAgFovNR6NRJ0EQEI/HBQihmkAgULxeuNHRUYVYLN6dTqcJAAC5XB6jaXpWqVTSAoFACgDF8XgcCQQCMBqN0NTUxN0FSBCEM5VK3eY/+w4kSapnZ2fzT58+jdLptAfHcVtWVhYbDofB5XJtm56e3tPV1fWlE/GNGzewvr6++vn5+R1utxvLzMwEhmEmKYqaAABwOp1bPB6PPpFIAADwyWTSvbq6eusuwH379sW1Wq0tIyODAwCIRCK5IpGooa6uTvT8888nCgoKruXk5CwjhGBwcJCw2Wzfcrlcjw0NDQm/CK6vrw9ZrdZtk5OTLwwNDakYhoHc3NwVtVr929raWv/Zs2cxHMe3R6NRA8dxIBQKeYVC4TCbzeQ9C7XRaLxSU1OTAABYWFiApaWl55LJ5ENKpZJXKpXdxcXF/QqFgqMoCgYGBswjIyM/unbt2uFLly4pRkdHP39WKpXCrl69Ku/u7n5scnLyfE9Pz9f8fj8iCILX6XS2/Pz8K/v370/rdDolTdP/dfPmTREAQHFxMWMymX7b1NSUuKf00dDQEE6n0+WLi4vmVCoFkUhExvM8ZbFYes6dOxdvbm52KpXKxz799FMFSZIwPT2toGn60Vgstq2/v19hMBgK6+rqyvr7+3dbrdajdrv9VG9vb63b7cYBAPbu3RusqKh45ejRo/1vv/02n5eXd+z69evHAoGAAACgvr5+YteuXa93dHRE7wm4Y8cOjqbpOM/zTW63W5pIJDCxWFxYV1fnf/XVV20CgcAnk8kWCYKo8Xq9uYlEAvl8PtnS0lKZ2+3eFQgE9pEkedDhcDwxOztbZ7fblZFIBMRiMb9nz57l2tra75nN5l9aLJZ0Xl5eQ19f38vj4+P5HMeh6upqxmg0/oAkyevDw8P8PQF7e3v55ubmCMMw2lgsVhEOhzGKorJisdjWiYmJ8fn5ed8zzzzjIAhiRiwWb6VpOpvneQlJklg4HJZEIhFpMBiUBoNBSSQSwbOzs0Gj0SSqqqomnnjiie/v2LHjF1evXk1euXJFPzo6enpqampnPB7HVSoVVFRUXNdqtefOnz8f/rPajNlsDrEs+5NgMFjh9Xr/ZXl5GZucnKzT6/Vn9+3bdyYjI6Pn+PHj1y5fvjwnEAgaUqnUoWQyafZ4PFlSqTQTwzAsEonEVSrVikKhmM/MzPywtLS0s6WlxUZRFBofH9/e0dHxosPhOOT3+4UIId5kMrlKSkre1mg03nXpg52dnfiNGzeOWK3WH37wwQdqlmVBKBRyTU1NCxqN5s2ysrKfnzp1arm1tRWPRqPqUChktNlsOZWVlUYcx4WTk5NzW7duDel0OqdYLF587rnn6M7OTnl3d3djMBh8+cMPP9wWDAaFCCHYuXNnrL6+/oxer//hiRMnkusWMHt6eojh4eETH3/88Xe7urq2MAwDYrEYjEZjtLa29v8NBsPPNBpNdzgcDmg0Go4gCDCZTCIAgFAoRM/NzcHS0hLSarU5drv9Yb/f/++Dg4OPzs3NKUOhEMIwDCwWC1VfX/+WxWL574MHDy5tWGFtb28nFhcXn+/p6flOf3+/NhQK4QAAeXl5fF5eXmz79u2enJyc38jl8hEMw3wGgwEEAgG4XC4+HA5nJxKJKoTQ4d7eXm0gEMjxer0Yx3GQmZnJV1RU+A8cOPATrVZ7/tlnnw3/xRLwpUuXBKOjo7ucTmeLx+PZbbPZZDRN3yHxqtVqxmQysWq1GnAch6WlJZidncV8Pp/Q7/ffMQmZzWa6sLBwpLi4+H/Lyso6T506lfqrNepgMIhdvHhRe/v27QOBQOBpu91e5/V6RRRFrXdQAK1Wy+v1+um8vLyflZaWftDY2GizWCxfOhBvSER//fXXRclkcitN0w0ej+fI4uKi2e/3Z+I4LvV6vVgymUQAACKRCAoLCzmCICiRSBTLz8+fLS0t/Y1AIPg1Quh2Y2Mj1djYuC7p7i/6DXH27FkMISSVSCTmiYkJrVKprLfZbEe6urryaZqG/fv3r5SXl3eIxeJBiUQyLZfLbdFoNFxUVMQdO3aMh6/aJicny0+ePDkqk8l4AOBPnDhBvv/++3v+bk91PM8Dx3H83y3gg4P7PwUgQujBDm4ocb/kenO0mfWY0+nE+vr6ciKRyNq5mA8EAkqO44RrPZfjODyZTOa+9dZb6rVmkJuby5nN5rDZbKY3FCobcX7ttdfwQCDwDZIkv7m6uprxWazxcrk8kyTJmuvXr2czDAO7d++mioqKRmOxWGBtDYIgOIVC0WsymS6cPHly9b7soM/ny56fnz8zOjqqZ1kWrX1KhBBKpVIYw/yh9w8NDYmtVusj/B+NMRiGIaPRaBGLxRMA8Lv7AuhyuZDP58sIBoP4vQSltcylKAooisL+tLsolUpiYWFBeN9iUKVSRdPp9FkMw/4tEoncE/KLSoxMJoOamprhkpKSsba2tvsTg5+NXBKXy6X1eDzCL1K47gVYUFDA19bWel944YUI/CPZ7wHq+s//p4jTJwAAAABJRU5ErkJggg==
"
	$script:Content_botonOn  = "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
"
	$script:Content_botonOff = "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
"
}




# main 

GenerateForm













