﻿
#Fichero codificado en UTF-8 con BOM porque sino powershell no pinta las tildes.
# EA4GXR  Fernando  (Celemín)  Febrero 2023 ©  
# Versión : 1.0 (01/03/2023)


# menu de proxima acción
function Opciones-Menu {
    param (
		[Parameter(Mandatory)]
        [string]$Titulo = 'My Menu'
    )
    # Clear-Host
    Write-Host "  ================" $Titulo "================"
    
    Write-Host "  1: Calibrar (de nuevo)"
    Write-Host "  2: Generar todos los diplomas"
	Write-Host "  3: Generar todos los diplomas y los pdf"
	Write-Host "  e: Editar .\diplomas.xml"
	Write-Host "  v: Ver carpeta diplomas"
	Write-Host "  h: Ayuda"
    Write-Host "  q: Salir"
	Write-Host
}

function ayuda {
	Write-host 
	Write-host "    Programa para generar diplomas de actividades de radio:"
	Write-host "      ( EA4GXR  Fernando  (Celemin)  Febrero 2023 © )"
	Write-Host "      diplomas.xml es el fichero de configuración "
	Write-Host "        Contiene comentarios sobre los campos a editar"
	Write-Host "      Editar .\diplomas.xml que es abierto automáticamente con notepad++"
	Write-Host "         Indicar fichero ADI, y rutas de plantilla y directorio de salida"
	Write-Host "      Elegir la opción calibrar para generar la vista previa "
	Write-Host "        Esto nos abre el visor por defecto de windows"   
	Write-Host "      Modificar diplomas.xml, guardar y calibrar las veces que sea necesario"
	Write-Host 
	Write-Host "      Para ver colores y fuentes, ver:"
	Write-Host "      https://imagemagick.org/script/color.php#color_names"
	Write-Host "      Ejecutar: explorer.exe c:\windows\fonts\" 
	Write-Host "         (vista previa / nombre fuente unido con - ej: Arial-Black) "
	Write-Host ""
}

function abrirNotepad {
    $miConfig = leerXMLdata
	try {
		$process = Start-Process -PassThru -FilePath $miConfig.notepadExePath -ArgumentList "-multiInst .\diplomas.xml"
	}
	catch {
		throw
	}
	finally {
		if ($process) {			

		}
	}

}


function verDiploma {
	 param (
		[Parameter(Mandatory)]
        [string]$ficheroDiploma
    )
	start "$ficheroDiploma" 
}

function verTodosDiplomas {
	$miConfig = leerXMLdata
	start $miConfig.dirSalida
}


class ConfigData
{
	[String] $magickExePath
	[String] $notepadExePath
	[String] $imagenPlantilla
	[String] $prefijoDiplomas
	[String] $baseDatosADI
	[String] $dirSalida
	[String] $posicionQRZ
	[String] $posicionQRA
	[String] $colorTexto
	[String] $fuenteTexto
	[String] $densidad
}


function leerXMLdata {
	# leo fichero xml como objeto
	[xml]$Data=Get-Content ".\diplomas.xml"

	$miData = New-Object -TypeName ConfigData

	# ejecutable de ImageMagick
	$miData.magickExePath   = $Data.diplomas.imageMagic
	$miData.notepadExePath  = $Data.diplomas.notepad_pp

	$miData.imagenPlantilla = $Data.diplomas.archivoPlantilla
	$miData.prefijoDiplomas = $Data.diplomas.prefijoDiplomas
	$miData.baseDatosADI    = $Data.diplomas.archivoADI
	$miData.dirSalida       = $Data.diplomas.dirSalida

	$miData.posicionQRZ     = $Data.diplomas.posicionQrz
	$miData.posicionQRA     = $Data.diplomas.posicionQra
	$miData.colorTexto      = $Data.diplomas.colorTexto
	$miData.fuenteTexto     = $Data.diplomas.fuenteTexto
	$miData.densidad        = $Data.diplomas.densidad
	
	$miData
}



function pintarXMLdata {
	
	param (
		[Parameter(Mandatory)]
		[ConfigData] $miData
	)
	
	Write-Host
	Write-Host "  Valores de configuración en .\diplomas.xml"
	Write-Host
	Write-host "    prefijoDiplomas:" $miData.prefijoDiplomas
	Write-host "    imagenPlantilla:" $miData.imagenPlantilla
	Write-host "    baseDatosADI:   " $miData.baseDatosADI
	Write-host "    Color Texto:    " $miData.colorTexto
	Write-host "    Fuente Texto:   " $miData.fuenteTexto
	Write-Host "    posicionQRZ:    " $miData.posicionQRZ
	Write-Host "    posicionQRA:    " $miData.posicionQRA
	Write-host "    dirSalida:      " $miData.dirSalida
	Write-Host
	
}

function crearDirYborrarFicherosOld {
	param (
		[Parameter(Mandatory)]
		[ConfigData] $miData
	)

	$outputDirectory = $miData.dirSalida

	if (!(Test-Path $outputDirectory -PathType Container)) {
		New-Item -ItemType Directory -Force -Path $outputDirectory
	}

	#borrar imagenes angiguas
	Remove-item ($outputDirectory + "\*") | where {$_.extension -in ".jpg",".png", ".pdf"}
}



#leer fichero .adi generado por javaQso
class ContactoQSL
{
	[String] $qrz
	[String] $qra
}


function leerADI {
	
		
	param (
		[Parameter(Mandatory)]
		[ConfigData] $miData
	)

	# Creo un ArrayList para guardar los contactos de un qso/diploma
	$qso = New-Object System.Collections.ArrayList


	foreach($line in Get-Content $miData.baseDatosADI) {
	
		$positionCALL = $line.ToLower().IndexOf("call:")
		if ($positionCALL -lt 0 ) 
		{
			continue
		}

		$result1 = $line.Substring($positionCALL)
		$posMayor = $result1.indexOf(">")
		$result2 = $result1.Substring($posMayor + 1)
		$posMenor = $result2.indexOf("<")
		$c_qrz = $result2.Substring(0, $posMenor - 1 ) # hay un espacio al final que quito

		$positionNAME = $line.ToLower().IndexOf("name:")
		$result1 = $line.Substring($positionNAME)
		$posMayor = $result1.indexOf(">")
		$result2 = $result1.Substring($posMayor + 1)
		$posMenor = $result2.indexOf("<")
		$c_qra = $result2.Substring(0, $posMenor - 1 ) # hay un espacio al final que quito
		
		# Write-Host ($c_qrz + ", " + $c_qra )
		$contacto = New-Object -TypeName ContactoQSL
		$contacto.qrz = $c_qrz.ToUpper()
		$contacto.qra = $c_qra.ToUpper()
		[void] $qso.Add($contacto)
		
	}
	$qso
}



function calibrar {
	$miConfig = leerXMLdata
	# Pintamos el contenido de .\diplomas.xml
	pintarXMLdata $miConfig
	crearDirYborrarFicherosOld $miConfig
	
	$outputDirectory = $miConfig.dirSalida
	
	$ListaContactos = leerADI $miConfig
	if($listaContactos.Count -ge 1) {
		$contacto = $listaContactos[0]	
				
		$diploma = Get-Item $miConfig.imagenPlantilla
		$diplomaQuoted = '"' + $diploma + '"'
		$outputFile = Split-Path $diploma.Basename -leaf
		$extension = (Split-Path -Path $diploma -Leaf).Split(".")[-1]; # -1 cuenta desde el final
		

		$outputFile = $miConfig.prefijoDiplomas + "-" + $contacto.qrz + "-" + 
			$contacto.qra + '.' + $extension

		
		$outPath = Join-Path -Path $outputDirectory -ChildPath $outputFile
		$outPath = '"' + $outPath + '"'
		Write-Host "    Fichero de salida = "  $outPath
		Write-Host	
		
		$arguments = 'convert',
		'-scale','1920x1080',
			'-gravity','center',
			$diplomaQuoted, $outPath
		& $miConfig.magickExePath $arguments


		$arguments = 'convert', $outPath,
				'-fill', $miConfig.colorTexto, 
				'-density', $miConfig.densidad, #'-pointsize', '50', 
				'-font', $miConfig.fuenteTexto,
				'-gravity', 'NorthWest',
				'-annotate', $miConfig.posicionQRZ, $contacto.qrz,
				'-annotate', $miConfig.posicionQRA, $contacto.qra,
				$outPath
		& $miConfig.magickExePath $arguments
		
		# ponemos rejilla (grid)
		$arguments = 'composite', 
			'.\fondoTransparenteGrid.png', $outPath,
			$outPath
		
		& $miConfig.magickExePath $arguments
		# lo abro con el programa por defecto del sistema.
		verDiploma $outPath
		
	} else{
		Write-Host "  Lista de contactos Vacia"
		return
	}

}

function ejecutar {
	Param(
		[switch] $pdf
	)
	
	$miConfig = leerXMLdata
	# Pintamos el contenido de .\diplomas.xml
	pintarXMLdata $miConfig
	crearDirYborrarFicherosOld $miConfig
	
	$outputDirectory = $miConfig.dirSalida
	
	$progreso = 0
	
	$ListaContactos = leerADI $miConfig
	foreach($contacto in $listaContactos) {
		
		$numRegs = $listaContactos.Count
		$porcentaje = [Math]::floor( $progreso / $numRegs * 100)
		
		$progreso++
		Write-Progress -Activity "Procesando" -Status "$porcentaje% Completado:" -PercentComplete $porcentaje 
		
		$diploma = Get-Item $miConfig.imagenPlantilla
		$diplomaQuoted = '"' + $diploma + '"'
		$outputFile = Split-Path $diploma.Basename -leaf
		$extension = (Split-Path -Path $diploma -Leaf).Split(".")[-1]; # -1 cuenta desde el final
		

		$outputFile = $miConfig.prefijoDiplomas + "-" + $contacto.qrz + "-" + 
			$contacto.qra + '.' + $extension

		
		$outPath = Join-Path -Path $outputDirectory -ChildPath $outputFile
		$outPath = '"' + $outPath + '"'
		Write-Host "    Fichero de salida = "  $outPath

		
		$arguments = 'convert',
		'-scale','1920x1080',
			'-gravity','center',
			$diplomaQuoted, $outPath
		& $miConfig.magickExePath $arguments


		$arguments = 'convert', $outPath,
				'-fill', $miConfig.colorTexto, 
				'-density', $miConfig.densidad, #'-pointsize', '50', 
				'-font', $miConfig.fuenteTexto,
				'-gravity', 'NorthWest',
				'-annotate', $miConfig.posicionQRZ, $contacto.qrz,
				'-annotate', $miConfig.posicionQRA, $contacto.qra,
				$outPath
		& $miConfig.magickExePath $arguments
	
	
		if($pdf) {
			$outPdf = $miConfig.prefijoDiplomas + "-" + $contacto.qrz + "-" + 
				$contacto.qra + '.pdf'
			$outPathPdf = Join-Path -Path $outputDirectory -ChildPath $outPdf
			$outPathPdf = '"' + $outPathPdf + '"'
			Write-Host "    fichero pdf = "  $outPathPdf
			$arguments = 'convert',
				$outPath,
				$outPathPdf
		
			& $miConfig.magickExePath $arguments
		}
	
	}
	Write-Host	

}

function ejecutarConPdf {
	ejecutar -pdf
}



# Limpiamos la pantalla
Clear-Host

#Ejecutamos ayuda al iniciar el script
ayuda
# Abrimos el .\diplomas.xml con notepad++
abrirNotepad
# Pintamos el contenido de .\diplomas.xml
$miConfig = leerXMLdata
pintarXMLdata $miConfig
Write-Host "  Abierto .\diplomasXML (Edítelo, grabe los cambios y ejecute calibrar.)"
Write-Host









while ($True)
{
	Opciones-Menu -Titulo "Siguiente acción"
	$selection = Read-Host "  Elige opción"
	switch ($selection)
		{
			  '1' {
				calibrar
			} '2' {
				ejecutar
			} '3' {
				ejecutarConPdf
			} 'e' {
				abrirNotepad	
			} 'v' {
				verTodosDiplomas		
			} 'h' {
				ayuda
		    } 'q' {
				return
			}
		
		}
	
}