/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC;

import ModeloQSO_MVC.ContactoRadio;
import ModeloQSO_MVC.ListContactsForExportXML;
import ModeloQSO_MVC.adif.ADIFField;
import ModeloQSO_MVC.adif.ADIFReader;
import ModeloQSO_MVC.adif.ADIFRecord;
import ModeloQSO_MVC.adif.ADIFWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdifFile {
    protected static final Logger parentLogger = LogManager.getLogger();
    private Logger logger = parentLogger;
    private ListContactsForExportXML lcfex;
    private ArrayList<ContactoRadio> alcr;
    private ArrayList<ADIFRecord> alAdifRecord;
    private final String adif_adif_ver = "2.2.7";
    private final String adif_programid = "javaQso";
    private final String adif_programversion = "1.0";
    private String adif_created_timestamp;

    public AdifFile(ListContactsForExportXML lcfex) {
        this.lcfex = lcfex;
        this.alcr = lcfex.getListCR();
        this.alAdifRecord = new ArrayList();
    }

    public AdifFile() {
        this.lcfex = new ListContactsForExportXML();
        this.alcr = new ArrayList();
        this.alAdifRecord = new ArrayList();
    }

    public void cargarRegistrosAdif() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmss");
        int diff = LocalDateTime.now().getHour() - LocalDateTime.now(Clock.systemUTC()).getHour();
        DateTimeFormatter formatterDia = DateTimeFormatter.ofPattern("yyyyMMdd");
        for (ContactoRadio cr : this.alcr) {
            ADIFRecord adifRecord = new ADIFRecord();
            LocalDate nowDate = LocalDate.now();
            LocalTime timeInLocal = cr.getHoraContacto();
            LocalDateTime dateTimeFromDateAndTime = LocalDateTime.of(nowDate, timeInLocal);
            LocalDateTime fechaFalsaEnUtc = dateTimeFromDateAndTime.minusHours(diff);
            LocalTime timeInUTC = fechaFalsaEnUtc.toLocalTime();
            LocalDateTime dateInUTC = cr.getDiaContacto().minusHours(diff);
            String[] qrzParts = cr.getQrz().split("_");
            String qrzAux = qrzParts[0];
            adifRecord.add(ADIFField.create("qso_date", dateInUTC.format(formatterDia)));
            adifRecord.add(ADIFField.create("band", this.lcfex.getBandContest()));
            adifRecord.add(ADIFField.create("freq", this.lcfex.getFrecContest()));
            adifRecord.add(ADIFField.create("mode", this.lcfex.getModeContest()));
            adifRecord.add(ADIFField.create("time_on", timeInUTC.format(formatter)));
            adifRecord.add(ADIFField.create("call", qrzAux.toUpperCase()));
            adifRecord.add(ADIFField.create("name", cr.getQra().toUpperCase()));
            adifRecord.add(ADIFField.create("qth", cr.getQth().toUpperCase()));
            adifRecord.add(ADIFField.create("email", cr.getEmail().toUpperCase()));
            adifRecord.add(ADIFField.create("notes", cr.getNotas().toUpperCase()));
            adifRecord.add(ADIFField.create("gridsquare", cr.getLocator().toUpperCase()));
            adifRecord.add(ADIFField.create("rst_sent", cr.getSigRadio() + cr.getSigSantiago()));
            adifRecord.add(ADIFField.create("tx_pwr", this.lcfex.getPowerContest()));
            adifRecord.add(ADIFField.create("my_name", cr.getQra().toUpperCase()));
            if (cr.isQsl()) {
                adifRecord.add(ADIFField.create("lotw_qsl_sent", "R"));
            } else {
                adifRecord.add(ADIFField.create("lotw_qsl_sent", "N"));
            }
            if (cr.isActivador()) {
                adifRecord.add(ADIFField.create("comment", "A"));
            } else {
                adifRecord.add(ADIFField.create("comment", Integer.toString(cr.getNum())));
            }
            this.alAdifRecord.add(adifRecord);
        }
    }

    public boolean escribirAFichero(String fichero) {
        boolean retorno = true;
        int diff = LocalDateTime.now().getHour() - LocalDateTime.now(Clock.systemUTC()).getHour();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fichero));){
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd HHmmss");
            DateTimeFormatter formatterDia = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
            DateTimeFormatter formatterDateContest = DateTimeFormatter.ofPattern("yyyyMMdd HHmmss");
            this.logger.debug("lcfex.getDateContest() = " + this.lcfex.getDateContest());
            this.logger.debug("lcfex.getStartContest() = " + this.lcfex.getStartContest());
            this.adif_created_timestamp = LocalDateTime.parse(this.lcfex.getDateContest() + " " + this.lcfex.getStartContest(), formatterDia).minusHours(diff).format(formatterDateContest);
            ADIFWriter adifWriter = new ADIFWriter(writer);
            adifWriter.writeHeaderField(ADIFField.create("adif_ver", "2.2.7"));
            adifWriter.writeHeaderField(ADIFField.create("created_timestamp", this.adif_created_timestamp));
            adifWriter.writeHeaderField(ADIFField.create("programid", "javaQso"));
            adifWriter.writeHeaderField(ADIFField.create("programversion", "1.0"));
            adifWriter.writeEOH();
            for (ADIFRecord ar : this.alAdifRecord) {
                adifWriter.writeRecord(ar);
            }
        }
        catch (Exception er) {
            this.logger.error("Lanzada excepci\u00f3n en AdifFile escribirAFichero() ");
            this.logger.error("Excepci\u00f3n! ", (Throwable)er);
            retorno = false;
        }
        return retorno;
    }

    public ListContactsForExportXML leerFichero(String fichero) {
        try {
            ADIFReader aReader = new ADIFReader(fichero);
            boolean haveHeader = false;
            while (aReader.ADIFReadHeaderLine() != null) {
                haveHeader = true;
            }
            ArrayList<ADIFField> alHeaderFields = new ArrayList<ADIFField>();
            if (haveHeader) {
                ADIFField af = aReader.ADIFReadHeaderField();
                while (!af.equals(ADIFField.create("eoh"))) {
                    alHeaderFields.add(af);
                    af = aReader.ADIFReadHeaderField();
                }
            }
            String adif_ver = "";
            String created_timestamp = "";
            String programid = "";
            String programversion = "";
            ADIFField adifVer = ADIFField.create("adif_ver");
            int index = alHeaderFields.indexOf(adifVer);
            if (index >= 0) {
                adif_ver = ((ADIFField)alHeaderFields.get(index)).getValue();
            }
            this.logger.debug("adif_ver: [" + adif_ver + "]");
            ADIFField createdTimestamp = ADIFField.create("created_timestamp");
            index = alHeaderFields.indexOf(createdTimestamp);
            if (index >= 0) {
                created_timestamp = ((ADIFField)alHeaderFields.get(index)).getValue();
            }
            this.logger.debug("created_timestamp: [" + created_timestamp + "]");
            ADIFField programId = ADIFField.create("programid");
            index = alHeaderFields.indexOf(programId);
            if (index >= 0) {
                programid = ((ADIFField)alHeaderFields.get(index)).getValue();
            }
            this.logger.debug("programid: [" + programid + "]");
            ADIFField programVersion = ADIFField.create("programversion");
            index = alHeaderFields.indexOf(programVersion);
            if (index >= 0) {
                programversion = ((ADIFField)alHeaderFields.get(index)).getValue();
            }
            this.logger.debug("programversion: [" + programversion + "]");
            String nameContest = "";
            String operatorContest = "";
            String startContest = "";
            String endContest = "";
            String bandContest = "";
            String frecContest = "";
            String modeContest = "";
            String powerContest = "";
            StringBuilder operators = new StringBuilder();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmss");
            int diff = LocalDateTime.now().getHour() - LocalDateTime.now(Clock.systemUTC()).getHour();
            DateTimeFormatter formatterDia = DateTimeFormatter.ofPattern("yyyyMMdd");
            ArrayList<ADIFRecord> alRecords = new ArrayList<ADIFRecord>();
            ADIFRecord ar = aReader.ADIFFReadRecord();
            boolean primeraVez = true;
            LocalTime timeOnAux = LocalTime.now();
            int j = 1;
            while (ar != null) {
                this.logger.debug("");
                alRecords.add(ar);
                String camposAux = new String();
                for (int i = 0; i < ar.getFieldCount(); ++i) {
                    ADIFField afAux = ar.getField(i);
                    camposAux = camposAux + "[" + afAux.getName() + ":" + afAux.getValue() + "] ";
                }
                this.logger.debug("camposAux = " + camposAux);
                ContactoRadio contactoRadio = new ContactoRadio();
                contactoRadio.setNum(j);
                if (ar.getField("qso_date") != null) {
                    contactoRadio.setDiaContacto(LocalDate.parse(ar.getField("qso_date").getValue(), formatterDia).atStartOfDay().plusHours(diff));
                }
                if (ar.getField("time_on") != null) {
                    String atmo = ar.getField("time_on").getValue();
                    if (atmo.length() == 4) {
                        atmo = atmo + "00";
                    }
                    timeOnAux = LocalTime.parse(atmo, formatter).plusHours(diff);
                    contactoRadio.setHoraContacto(timeOnAux);
                }
                if (primeraVez) {
                    if (ar.getField("band") != null) {
                        bandContest = ar.getField("band").getValue();
                    }
                    if (ar.getField("freq") != null) {
                        frecContest = ar.getField("freq").getValue();
                    }
                    if (ar.getField("mode") != null) {
                        modeContest = ar.getField("mode").getValue();
                    }
                    if (ar.getField("time_on") != null) {
                        DateTimeFormatter formatterAux = DateTimeFormatter.ofPattern("HH:mm");
                        String atmo = ar.getField("time_on").getValue();
                        if (atmo.length() == 4) {
                            atmo = atmo + "00";
                        }
                        startContest = LocalTime.parse(atmo, formatter).plusHours(diff).format(formatterAux);
                    }
                    primeraVez = false;
                }
                if (ar.getField("call") != null) {
                    contactoRadio.setQrz(ar.getField("call").getValue());
                }
                if (ar.getField("name") != null) {
                    contactoRadio.setQra(ar.getField("name").getValue());
                }
                if (ar.getField("qth") != null) {
                    contactoRadio.setQth(ar.getField("qth").getValue());
                }
                if (ar.getField("email") != null) {
                    contactoRadio.setEmail(ar.getField("email").getValue());
                }
                if (ar.getField("notes") != null) {
                    contactoRadio.setNotas(ar.getField("notes").getValue());
                }
                if (ar.getField("gridsquare") != null) {
                    contactoRadio.setLocator(ar.getField("gridsquare").getValue());
                }
                if (ar.getField("rst_sent") != null && ar.getField("rst_sent").getValue().length() > 1) {
                    contactoRadio.setSigRadio(ar.getField("rst_sent").getValue().substring(0, 1));
                    contactoRadio.setSigSantiago(ar.getField("rst_sent").getValue().substring(1, 2));
                }
                if (ar.getField("tx_pwr") != null) {
                    powerContest = ar.getField("tx_pwr").getValue();
                }
                if (ar.getField("my_name") != null) {
                    operatorContest = ar.getField("my_name").getValue() + "(" + ar.getField("call").getValue() + ")";
                }
                if (ar.getField("lotw_qsl_sent") != null) {
                    String cadSendQsl = ar.getField("lotw_qsl_sent").getValue();
                    if (cadSendQsl.equalsIgnoreCase("R")) {
                        contactoRadio.setQsl(true);
                    } else {
                        contactoRadio.setQsl(false);
                    }
                }
                if (ar.getField("comment") != null) {
                    String cadIsActivador = ar.getField("comment").getValue();
                    if (cadIsActivador.equalsIgnoreCase("A")) {
                        contactoRadio.setActivador(true);
                        if (operators.length() != 0) {
                            operators.append(", ");
                        }
                        operators.append(operatorContest);
                    } else {
                        contactoRadio.setActivador(false);
                    }
                }
                this.alcr.add(contactoRadio);
                ar = aReader.ADIFFReadRecord();
                ++j;
            }
            DateTimeFormatter formatterAux = DateTimeFormatter.ofPattern("HH:mm");
            endContest = timeOnAux.format(formatterAux);
            this.logger.debug("Le\u00eddos todos los records");
            this.lcfex.setListCR(this.alcr);
            String nameOfFile = new File(fichero).getName();
            this.lcfex.setNameContest(nameOfFile.substring(0, nameOfFile.toLowerCase().lastIndexOf(".adi")));
            if (operators.length() != 0) {
                this.lcfex.setOperatorContest(operators.toString());
            } else {
                this.lcfex.setOperatorContest(operatorContest + " ??");
            }
            if (!created_timestamp.equals("")) {
                DateTimeFormatter formatterDateContest = DateTimeFormatter.ofPattern("yyyyMMdd HHmmss");
                LocalDateTime dateTime = LocalDateTime.parse(created_timestamp, formatterDateContest);
                DateTimeFormatter formatterDateContestCorto = DateTimeFormatter.ofPattern("dd/MM/yyyy");
                this.lcfex.setDateContest(dateTime.plusHours(diff).format(formatterDateContestCorto));
            } else {
                this.lcfex.setDateContest("");
            }
            this.lcfex.setStartContest(startContest);
            this.lcfex.setEndContest(endContest);
            this.lcfex.setBandContest(bandContest);
            this.lcfex.setFrecContest(frecContest);
            this.lcfex.setModeContest(modeContest);
            this.lcfex.setPowerContest(powerContest);
        }
        catch (Exception e) {
            this.logger.error("Excepci\u00f3n! ", (Throwable)e);
            this.lcfex = new ListContactsForExportXML();
        }
        return this.lcfex;
    }
}

