/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC;

import java.io.Serializable;
import java.util.Objects;

public class CompRadio
implements Comparable<CompRadio>,
Serializable {
    private String qrz;
    private String qra;
    private String qth;
    private String locator;
    private String rc;
    private String email;
    private String pobox;

    public CompRadio() {
        this.qrz = "";
        this.qra = "";
        this.qth = "";
        this.locator = "";
        this.rc = "";
        this.email = "";
        this.pobox = "";
    }

    public CompRadio(CompRadio cmpr) {
        this.qrz = cmpr.getQrz();
        this.qra = cmpr.getQra();
        this.qth = cmpr.getQth();
        this.locator = cmpr.getLocator();
        this.rc = cmpr.getRc();
        this.email = cmpr.getEmail();
        this.pobox = cmpr.getPobox();
    }

    public CompRadio(String qrz, String qra, String qth, String locator, String rc, String email, String pobox) {
        this.qrz = this.capitalizeFirstLetter(qrz);
        this.qra = this.capitalizeFirstLetter(qra);
        this.qth = this.capitalizeFirstLetter(qth);
        this.locator = locator.toUpperCase();
        this.rc = rc;
        this.email = email.toLowerCase();
        this.pobox = pobox;
    }

    public String getQth() {
        return this.qth;
    }

    public void setQth(String qth) {
        this.qth = this.capitalizeFirstLetter(qth);
    }

    public String getQra() {
        return this.qra;
    }

    public void setQra(String qra) {
        this.qra = this.capitalizeFirstLetter(qra);
    }

    public String getQrz() {
        return this.qrz;
    }

    public void setQrz(String qrz) {
        this.qrz = this.capitalizeFirstLetter(qrz);
    }

    public String getRc() {
        return this.rc;
    }

    public void setRc(String rc) {
        this.rc = rc;
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator.toUpperCase();
    }

    public String getEmail() {
        return this.email;
    }

    public String getPobox() {
        return this.pobox;
    }

    public void setEmail(String email) {
        this.email = email.toLowerCase();
    }

    public void setPobox(String pobox) {
        this.pobox = pobox;
    }

    @Override
    public int compareTo(CompRadio cr) {
        if (Character.isDigit(this.getQrz().charAt(0)) && Character.isDigit(cr.getQrz().charAt(0))) {
            return this.getQrz().toUpperCase().compareTo(cr.getQrz().toUpperCase());
        }
        if (Character.isDigit(this.getQrz().charAt(0))) {
            return 1;
        }
        if (Character.isDigit(cr.getQrz().charAt(0))) {
            return -1;
        }
        return this.getQrz().toUpperCase().compareTo(cr.getQrz().toUpperCase());
    }

    public String toString() {
        return "CompRadio{qrz=" + this.qrz + ", qra=" + this.qra + ", qth=" + this.qth + ", locator=" + this.locator + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Objects.hashCode(this.qrz);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompRadio other = (CompRadio)obj;
        String qrz1 = this.qrz.toUpperCase();
        String qrz2 = other.qrz.toUpperCase();
        return Objects.equals(qrz1, qrz2);
    }

    private String capitalizeFirstLetter(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1).toLowerCase();
    }
}

