/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC;

import java.io.File;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GestorCorreo {
    protected static final Logger parentLogger = LogManager.getLogger();
    private Logger logger = parentLogger;
    private Properties mailQsoProperties;
    private String senderMailAcount;
    private String senderPassword;
    private String adminAccount;
    private String controlAccount;
    private String emailConfirm;

    public GestorCorreo(Properties mailQsoProperties, String senderMailAcount, String senderPassword, String adminAccount, String controlAccount, String emailConfirm) {
        this.mailQsoProperties = mailQsoProperties;
        this.senderMailAcount = senderMailAcount;
        this.senderPassword = senderPassword;
        this.adminAccount = adminAccount;
        this.controlAccount = controlAccount;
        this.emailConfirm = emailConfirm;
    }

    public boolean enviarFichero(File file) {
        boolean resultado = true;
        Session session1 = Session.getInstance(this.mailQsoProperties);
        MimeBodyPart texto = new MimeBodyPart();
        try {
            texto.setText("Log de actividad enviado desde la aplicaci\u00f3n javaQso por: " + this.emailConfirm);
            MimeBodyPart adjunto = new MimeBodyPart();
            adjunto.setDataHandler(new DataHandler(new FileDataSource(file)));
            adjunto.setFileName(file.getName());
            MimeMultipart multiParte = new MimeMultipart();
            multiParte.addBodyPart(texto);
            multiParte.addBodyPart(adjunto);
            MimeMessage message = new MimeMessage(session1);
            message.setFrom(new InternetAddress(this.senderMailAcount));
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(this.adminAccount));
            message.addRecipient(Message.RecipientType.BCC, new InternetAddress(this.controlAccount));
            message.addRecipient(Message.RecipientType.CC, new InternetAddress(this.emailConfirm));
            message.setSubject("Fichero Adif javaQso: " + file.getName());
            message.setContent(multiParte);
            try (Transport t = session1.getTransport("smtp");){
                t.connect(this.senderMailAcount, this.senderPassword);
                t.sendMessage(message, message.getAllRecipients());
            }
        }
        catch (MessagingException ex) {
            this.logger.debug("Excepci\u00f3n lanzada al enviar mail fichero");
            resultado = false;
        }
        return resultado;
    }
}

