/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC.adif;

import ModeloQSO_MVC.adif.ADIFException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ADIFField {
    protected static final Logger parentLogger = LogManager.getLogger();
    private Logger logger = parentLogger;
    private String recordName;
    private String type;
    private String value;

    public static ADIFField create(String name) {
        return new ADIFField(name, null, null);
    }

    public static ADIFField create(String name, String value) {
        return new ADIFField(name, null, value);
    }

    public static ADIFField create(String name, String type, String value) {
        return new ADIFField(name, type, value);
    }

    public static ADIFField read(Reader in) throws ADIFException {
        return ADIFField.parse(in);
    }

    public ADIFField(String name, String type, String value) {
        this.recordName = name;
        this.type = type;
        this.value = value;
    }

    public void write(BufferedWriter out) throws IOException {
        StringBuilder sb = new StringBuilder();
        int length = this.value.length();
        sb.append('<').append(this.recordName).append(':').append(length);
        if (this.type != null) {
            sb.append(':').append(this.type);
        }
        sb.append(">");
        if (this.value != null) {
            sb.append(this.value);
        }
        sb.append(' ');
        out.write(sb.toString());
    }

    public String getName() {
        return this.recordName;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    private static ADIFField parse(Reader buf) throws ADIFException {
        StringBuilder name = new StringBuilder();
        StringBuilder length = new StringBuilder();
        StringBuilder type = new StringBuilder();
        StringBuilder value = new StringBuilder();
        int state = 0;
        int fieldlen = 0;
        try {
            String cadAuxChar = new String();
            block12: while (true) {
                switch (state) {
                    case 0: {
                        int c = buf.read();
                        cadAuxChar = cadAuxChar + "" + (char)c;
                        if (c == -1) {
                            return null;
                        }
                        if (Character.isWhitespace((char)c)) continue block12;
                        if (c == 60) {
                            state = 1;
                            break;
                        }
                        throw new ADIFException("Invalid character '" + (char)c + "'. Excepted '<'.");
                    }
                    case 1: {
                        int c = buf.read();
                        cadAuxChar = cadAuxChar + "" + (char)c;
                        if (c == 58) {
                            state = 2;
                            break;
                        }
                        if (c == 62) {
                            state = 4;
                            break;
                        }
                        if (c == 95 || Character.isLetterOrDigit((char)c)) {
                            name.append((char)c);
                            break;
                        }
                        if (c == -1) {
                            throw new ADIFException("Unexpected end-of-file encountered while reading ADIF record.");
                        }
                        throw new ADIFException("Invalid character '" + (char)c + "'.");
                    }
                    case 2: {
                        int c = buf.read();
                        cadAuxChar = cadAuxChar + "" + (char)c;
                        if (c == 58) {
                            state = 3;
                            break;
                        }
                        if (c == 62) {
                            state = 4;
                            break;
                        }
                        if (Character.isDigit((char)c)) {
                            length.append((char)c);
                            break;
                        }
                        if (c == -1) {
                            throw new ADIFException("Unexpected end-of-file encountered while reading ADIF record.");
                        }
                        throw new ADIFException("Invalid character '" + (char)c + "'.");
                    }
                    case 3: {
                        int c = buf.read();
                        cadAuxChar = cadAuxChar + "" + (char)c;
                        if (c == 62) {
                            state = 4;
                            break;
                        }
                        if (Character.isLetterOrDigit((char)c)) {
                            type.append((char)c);
                            break;
                        }
                        throw new ADIFException("Invalid character '" + (char)c + "'.");
                    }
                    case 4: {
                        state = 5;
                        if (length.length() > 0) {
                            try {
                                fieldlen = Integer.parseInt(length.toString());
                            }
                            catch (NumberFormatException e) {
                                throw new ADIFException("Can't parse field length '" + length + "'.", e);
                            }
                        }
                    }
                    case 5: {
                        int c;
                        if (--fieldlen >= 0) {
                            c = buf.read();
                            cadAuxChar = cadAuxChar + "" + (char)c;
                            if (c == -1) {
                                throw new ADIFException("Unexpected end-of-file encountered while reading ADIF record.");
                            }
                            value.append((char)c);
                            break;
                        }
                        parentLogger.debug("cadAuxChar = " + cadAuxChar);
                        return ADIFField.create(name.toString(), type.toString(), value.toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ADIFException("Malformed field.", e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ADIFField other = (ADIFField)obj;
        return Objects.equals(this.getName().toUpperCase(), other.getName().toUpperCase());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.recordName);
        hash = 97 * hash + Objects.hashCode(this.type);
        hash = 97 * hash + Objects.hashCode(this.value);
        return hash;
    }
}

