/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC.adif;

import ModeloQSO_MVC.adif.ADIFException;
import ModeloQSO_MVC.adif.ADIFField;
import ModeloQSO_MVC.adif.ADIFRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ADIFReader {
    protected static final Logger parentLogger = LogManager.getLogger();
    private Logger logger = parentLogger;
    private BufferedReader in;
    private static final String END_OF_HEADER = "eoh";

    public ADIFReader(BufferedReader input) throws IOException {
        this.in = new BufferedReader(input);
    }

    public ADIFReader(String fileName) throws IOException {
        boolean empty;
        File file = new File(fileName);
        boolean bl = empty = !file.exists() || file.length() == 0L;
        if (empty) {
            throw new IOException("El fichero no existe o est\u00e1 vac\u00edo");
        }
        this.in = new BufferedReader(new FileReader(file));
    }

    public String ADIFReadHeaderLine() throws IOException {
        String str = "";
        this.logger.debug("mark support: " + this.in.markSupported());
        this.in.mark(1000);
        int c = this.in.read();
        while (Character.isWhitespace((char)c)) {
            c = this.in.read();
        }
        this.in.reset();
        str = c == 60 ? null : this.in.readLine();
        return str;
    }

    public ADIFField ADIFReadHeaderField() throws IOException, ADIFException {
        ADIFField af = ADIFField.read(this.in);
        if (af != null) {
            String nameAF = af.getName();
            this.logger.debug("af.getName() = " + nameAF);
            if (af.getName().equalsIgnoreCase(END_OF_HEADER)) {
                this.logger.debug("af contiene eor ");
            }
        }
        return af;
    }

    public ADIFRecord ADIFFReadRecord() throws ADIFException {
        return ADIFRecord.read(this.in);
    }
}

