/*
 * Decompiled with CFR 0.152.
 */
package ModeloQSO_MVC.adif;

import ModeloQSO_MVC.adif.ADIFField;
import ModeloQSO_MVC.adif.ADIFRecord;
import java.io.BufferedWriter;
import java.io.IOException;

public class ADIFWriter {
    private static final String END_OF_HEADER = "<eoh>";
    private final BufferedWriter bw;

    public ADIFWriter(BufferedWriter out) {
        this.bw = out;
    }

    public void writeHeaderString(String sHeader) throws IOException {
        if (sHeader != null) {
            this.bw.write(sHeader);
            this.bw.newLine();
        }
    }

    public void writeHeaderField(ADIFField af) throws IOException {
        af.write(this.bw);
        this.bw.newLine();
    }

    public void writeEOH() throws IOException {
        this.bw.write(END_OF_HEADER);
        this.bw.newLine();
    }

    public void writeRecord(ADIFRecord record) throws IOException {
        record.write(this.bw);
    }
}

