﻿Param(
	[String] $cadBusqueda = $null,
	[switch] $qrz,   # filtrar si solo quiero qrz o qra o todos
	[switch] $qra,
	[switch] $todos
	)


# Write-Host
# Write-Host "Buscando: " $cadBusqueda
# Write-Host
Clear-Host


function ayuda {
	Write-host 
	Write-host "    Programa para buscar en la base de datos de javaQso"
	Write-host "      ( EA4GXR  Fernando  (Celemin)  Marzo 2023 © )"
	Write-Host "    Puede usarse sin parámetros y entonces funciona en modo interactivo. "
	Write-Host "    La cadena de busqueda puede contener caracteres comodin * como alfa* "
	Write-Host "    Para ejecuatar con parámetros:"
	Write-Host "    .\buscar.ps1 [-qrz] [-qra] [-todos] cadenaBusqueda"
	Write-Host "    esto permite buscar por qrz, por qra o por todos los campos"
	Write-Host "    Debe instalarse junto al ejecutable de javaQso."   
	Write-Host 
	Write-Host 
}






function WriteXmlToScreen ([xml]$xml)
{
    $StringWriter = New-Object System.IO.StringWriter;
    $XmlWriter = New-Object System.Xml.XmlTextWriter $StringWriter;
    $XmlWriter.Formatting = "indented";
    $xml.WriteTo($XmlWriter);
    $XmlWriter.Flush();
    $StringWriter.Flush();
    Write-Output $StringWriter.ToString();
}

# menu de proxima acción
function Opciones-Menu {
    param (
		[Parameter(Mandatory)]
        [string]$Titulo = 'My Menu'
    )
    # Clear-Host
	Write-Host
    Write-Host " ==" $Titulo "=="
    Write-Host
    Write-Host "  1: Buscar por QRZ"
    Write-Host "  2: Buscar por QRA"
	Write-Host "  3: Buscar cualquier cadena"
	Write-Host "  h: Ayuda"
    Write-Host "  q: Salir"
	Write-Host
}


	Write-Host 
	# Write-Host cadBusqueda: $cadBusqueda


	$scriptPath = $MyInvocation.MyCommand.Path
	# Write-Host scriptPath = $scriptPath
	$scriptDirectory = Split-Path $scriptPath
	# Write-Host scriptDirectory = $scriptDirectory

	$pathEstaciones = Join-Path -Path $scriptDirectory -ChildPath ".javaQso"
    $pathEstaciones = Join-Path -Path $pathEstaciones -ChildPath "javaQsoEstaciones.xml"
	# Write-Host pathEstaciones: $pathEstaciones
	# Write-Host
	
	
	[xml]$Data=Get-Content $pathEstaciones
	
	# WriteXmlToScreen $Data
	
	# Select-Xml -Xml $Data -XPath "//Estacion//qrz" | where-object {$_.node.InnerXML -eq "celemin"} | Write-Host
	
	# foreach ($node in $Data.JavaQso.Estacion.ChildNodes)
	# {
		# if ($node.InnerXML -eq "Fernando") 
		# { 
			# $node.OuterXml
		# }	
	# }
	
	# $Data.ChildNodes.selectNodes("Estacion") 
	
	# https://adamtheautomator.com/powershell-parse-xml/
	# https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.core/where-object?view=powershell-7.3
	
	# $Data.JavaQso.Estacion | Where-Object qrz -eq 'Celemin' | ForEach-Object {
		
		
		
	function buscar {
		Param(
		[String] $cad,
		[switch] $qrz,   # filtrar si solo quiero qrz o qra o todos
		[switch] $qra,
		[switch] $todos
		)	
		
			
		if(($qrz -and !$todos) -or (!$qrz -and !$qra -and !$todos )) {
			
			$Data.JavaQso.Estacion | Where-Object qrz -like $cad | ForEach-Object {
				# $_.OuterXml
				# Write-Host
				# $_.InnerXml
				# Write-Host
				
				# https://learn.microsoft.com/es-es/powershell/scripting/learn/deep-dives/everything-about-pscustomobject?view=powershell-7.3
				## output the result object
				[pscustomobject]@{
					qrz = $_.qrz
					qra = $_.qra
					qth = $_.qth
					locator = $_.locator
					rc = $_.rc
					email = $_.email
				}

			}
		}
			
		if($qra -and !$todos ) {	
			$Data.JavaQso.Estacion | Where-Object qra -like $cad| ForEach-Object {
				[pscustomobject]@{
					qrz = $_.qrz; qra = $_.qra;	qth = $_.qth;
					locator = $_.locator; rc = $_.rc; email = $_.email
				}
			}	
		}		
		

		if($todos ) {	
			$Data.JavaQso.Estacion | Where-Object { $_.qrz -like $cad -or
													$_.qra -like $cad -or
													$_.qth -like $cad -or
													$_.locator -like $cad -or
													$_.email -like $cad}| ForEach-Object {
				[pscustomobject]@{
					qrz = $_.qrz; qra = $_.qra;	qth = $_.qth;
					locator = $_.locator; rc = $_.rc; email = $_.email
				}
			}		
		}
	
	}

# Mostramos la ayuda	
ayuda
	
if ($cadBusqueda) {

	buscar $cadBusqueda -qrz:$qrz -qra:$qra -todos:$todos

} else {
		
	while ($True)
	{
		
		Opciones-Menu -Titulo "Elija criterio de búsqueda"
		$selection = Read-Host "  Elija opción"
		$cad = "celemin"
		switch ($selection)
			{
				  '1' {
					$cad = Read-Host "  Introduzca QRZ"
					buscar $cad -qrz 
				} '2' {
					$cad = Read-Host "  Introduzca QRA"
					buscar $cad -qra
				} '3' {
					$cad = Read-Host "  Introduzca cadena a buscar"
					buscar $cad -todos
				} 'h' {
					ayuda
				} 'q' {
					return
				}
			
			}
		
	}
	
} # else